﻿---
title: _id field
description: Each document has an _id that uniquely identifies it, which is indexed so that documents can be looked up either with the GET API or the ids query. The...
url: https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/mapping-id-field
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# _id field
Each document has an `_id` that uniquely identifies it, which is indexed so that documents can be looked up either with the [GET API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-get) or the [`ids` query](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-ids-query). The `_id` can either be assigned at indexing time, or a unique `_id` can be generated by Elasticsearch. This field is not configurable in the mappings.
The value of the `_id` field is accessible in queries such as `term`, `terms`, `match`, and `query_string`.
```json
# Example documents

{
  "text": "Document with ID 1"
}


{
  "text": "Document with ID 2"
}


{
  "query": {
    "terms": {
      "_id": [ "1", "2" ] <1>
    }
  }
}
```

The `_id` field is restricted from use in aggregations, sorting, and scripting. In case sorting or aggregating on the `_id` field is required, it is advised to duplicate the content of the `_id` field into another field that has `doc_values` enabled.
<note>
  `_id` is limited to 512 bytes in size and larger values will be rejected.
</note>