﻿---
title: index_prefixes
description: The index_prefixes parameter enables the indexing of term prefixes to speed up prefix searches. It accepts the following optional settings: This example...
url: https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/index-prefixes
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# index_prefixes
The `index_prefixes` parameter enables the indexing of term prefixes to speed up prefix searches. It accepts the following optional settings:
<definitions>
  <definition term="min_chars">
    The minimum prefix length to index. Must be greater than 0, and defaults to 2. The value is inclusive.
  </definition>
  <definition term="max_chars">
    The maximum prefix length to index. Must be less than 20, and defaults to 5. The value is inclusive.
  </definition>
</definitions>

This example creates a text field using the default prefix length settings:
```json

{
  "mappings": {
    "properties": {
      "body_text": {
        "type": "text",
        "index_prefixes": { }    <1>
      }
    }
  }
}
```

This example uses custom prefix length settings:
```json

{
  "mappings": {
    "properties": {
      "full_name": {
        "type": "text",
        "index_prefixes": {
          "min_chars" : 1,
          "max_chars" : 10
        }
      }
    }
  }
}
```

`index_prefixes` parameter instructs Elasticsearch to create a subfield "._index_prefix". This field will be used to do fast prefix queries. When doing highlighting, add "._index_prefix" subfield to the `matched_fields` parameter to highlight the main field based on the found matches of the prefix field, like in the request below:
```json

{
  "query": {
    "prefix": {
      "full_name": {
        "value": "ki"
      }
    }
  },
  "highlight": {
    "fields": {
      "full_name": {
        "matched_fields": ["full_name._index_prefix"]
      }
    }
  }
}
```