﻿---
title: index_options
description: The index_options parameter controls what information is added to the inverted index for search and highlighting purposes. Only term-based field types...
url: https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/index-options
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# index_options
The `index_options` parameter controls what information is added to the inverted index for search and highlighting purposes. Only term-based field types like [`text`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/text) and [`keyword`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/keyword) support this configuration.
The parameter accepts one of the following values. Each value retrieves information from the previous listed values. For example, `freqs` contains `docs`; `positions` contains both `freqs` and `docs`.
<definitions>
  <definition term="docs">
    Only the doc number is indexed. Can answer the question *Does this term exist in this field?*
  </definition>
  <definition term="freqs">
    Doc number and term frequencies are indexed. Term frequencies are used to score repeated terms higher than single terms.
  </definition>
  <definition term="positions (default)">
    Doc number, term frequencies, and term positions (or order) are indexed. Positions can be used for [proximity or phrase queries](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-match-query-phrase).
  </definition>
  <definition term="offsets">
    Doc number, term frequencies, positions, and start and end character offsets (which map the term back to the original string) are indexed. Offsets are used by the [unified highlighter](/docs/reference/elasticsearch/rest-apis/highlighting#unified-highlighter) to speed up highlighting.
  </definition>
</definitions>

```json

{
  "mappings": {
    "properties": {
      "text": {
        "type": "text",
        "index_options": "offsets"
      }
    }
  }
}


{
  "text": "Quick brown fox"
}


{
  "query": {
    "match": {
      "text": "brown fox"
    }
  },
  "highlight": {
    "fields": {
      "text": {} <1>
    }
  }
}
```