﻿---
title: ignore_above index setting
description: The ignore_above field-level setting can also be applied at the index level using index.mapping.ignore_above. This setting lets you define a maximum string...
url: https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/index-mapping-ignore-above
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# ignore_above index setting
The [`ignore_above` field-level setting](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/ignore-above) can also be applied at the index level using `index.mapping.ignore_above`. This setting lets you define a maximum string length for all applicable fields across the index, including `keyword`, `wildcard`, and keyword values in `flattened` fields. Any values that exceed this limit will be [ignored](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/mapping-ignored-field) during indexing and won’t be stored.
This index-level setting ensures a consistent approach to managing excessively long values. It works the same as the field-level setting—if a string’s length goes over the specified limit, that string won’t be indexed or stored. When dealing with arrays, each element is evaluated separately, and only the elements that exceed the limit are ignored.
```json

{
  "settings": {
    "index.mapping.ignore_above": 256
  }
}
```

In this example, all applicable fields in `my-index-000001` will ignore any strings longer than 256 characters.
<tip>
  You can override this index-wide setting for specific fields by specifying a custom `ignore_above` value in the field mapping.
</tip>

<note>
  Just like the field-level `ignore_above`, this setting only affects indexing and storage. The original values are still available in the `_source` field if `_source` is enabled, which is the default behavior in Elasticsearch.
</note>