﻿---
title: ignore_above
description: Strings longer than the ignore_above setting will not be indexed or stored. For arrays of strings, ignore_above will be applied for each array element...
url: https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/ignore-above
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# ignore_above
Strings longer than the `ignore_above` setting will not be indexed or stored. For arrays of strings, `ignore_above` will be applied for each array element separately and string elements longer than `ignore_above` will not be indexed or stored.
<note>
  All strings/array elements will still be present in the `_source` field, if the latter is enabled which is the default in Elasticsearch.
</note>

```json

{
  "mappings": {
    "properties": {
      "message": {
        "type": "keyword",
        "ignore_above": 20 <1>
      }
    }
  }
}


{
  "message": "Syntax error"
}


{
  "message": "Syntax error with some long stacktrace"
}


{
  "aggs": {
    "messages": {
      "terms": {
        "field": "message"
      }
    }
  }
}
```

<tip>
  The `ignore_above` setting can be updated on existing fields using the [update mapping API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-put-mapping).
</tip>

This option is also useful for protecting against Lucene’s term byte-length limit of `32766`.
<note>
  The value for `ignore_above` is the *character count*, but Lucene counts bytes. If you use UTF-8 text with many non-ASCII characters, you may want to set the limit to `32766 / 4 = 8191` since UTF-8 characters may occupy at most 4 bytes.
</note>