﻿---
title: Field data types
description: Each field has a field data type, or field type. This type indicates the kind of data the field contains, such as strings or boolean values, and its intended...
url: https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/field-data-types
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Field data types
Each field has a *field data type*, or *field type*. This type indicates the kind of data the field contains, such as strings or boolean values, and its intended use. For example, you can index strings to both `text` and `keyword` fields. However, `text` field values are [analyzed](https://www.elastic.co/docs/manage-data/data-store/text-analysis) for full-text search while `keyword` strings are left as-is for filtering and sorting.
Field types are grouped by *family*. Types in the same family have exactly the same search behavior but may have different space usage or performance characteristics.
Currently, there are two type families, `keyword` and `text`. Other type families have only a single field type. For example, the `boolean` type family consists of one field type: `boolean`.

### Common types

<definitions>
  <definition term="binary">
    Binary value encoded as a Base64 string.
  </definition>
  <definition term="boolean">
    `true` and `false` values.
  </definition>
  <definition term="Keywords">
    The keyword family, including `keyword`, `constant_keyword`, and `wildcard`.
  </definition>
  <definition term="Numbers">
    Numeric types, such as `long` and `double`, used to express amounts.
  </definition>
  <definition term="Dates">
    Date types, including [`date`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/date) and [`date_nanos`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/date_nanos).
  </definition>
  <definition term="alias">
    Defines an alias for an existing field.
  </definition>
</definitions>


### Objects and relational types

<definitions>
  <definition term="object">
    A JSON object.
  </definition>
  <definition term="flattened">
    An entire JSON object as a single field value.
  </definition>
  <definition term="nested">
    A JSON object that preserves the relationship between its subfields.
  </definition>
  <definition term="join">
    Defines a parent/child relationship for documents in the same index.
  </definition>
  <definition term="passthrough">
    Provides aliases for sub-fields at the same level.
  </definition>
</definitions>


### Structured data types

<definitions>
  <definition term="Range">
    Range types, such as `long_range`, `double_range`, `date_range`, and `ip_range`.
  </definition>
  <definition term="ip">
    IPv4 and IPv6 addresses.
  </definition>
  <definition term="version">
    Software versions. Supports [Semantic Versioning](https://semver.org/) precedence rules.
  </definition>
  <definition term="murmur3">
    Compute and stores hashes of values.
  </definition>
</definitions>


### Aggregate data types

<definitions>
  <definition term="aggregate_metric_double">
    Pre-aggregated metric values.
  </definition>
  <definition term="histogram">
    Pre-aggregated numerical values in the form of a T-Digest or HDRhistogram.
  </definition>
  <definition term="exponential_histogram">
    Pre-aggregated numerical values in the form of an exponential histogram.
  </definition>
  <definition term="tdigest Elastic Stack: Preview since 9.3 Elastic Cloud Serverless: Preview">
    Pre-aggregated numerical values in the form of a T-Digest.
  </definition>
</definitions>


### Text search types

<definitions>
  <definition term="text fields">
    The text family, including `text`, `match_only_text`, and `pattern_text`. Analyzed, unstructured text.
  </definition>
  <definition term="annotated-text">
    Text containing special markup. Used for identifying named entities.
  </definition>
  <definition term="[completion]">
    Used for auto-complete suggestions. For more information about completion suggesters, refer to [Suggester examples](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/search-suggesters).
  </definition>
  <definition term="search_as_you_type">
    `text`-like type for as-you-type completion.
  </definition>
  <definition term="semantic_text">
    Used for performing [semantic search](https://www.elastic.co/docs/solutions/search/semantic-search).
  </definition>
  <definition term="token_count">
    A count of tokens in a text.
  </definition>
</definitions>


### Document ranking types

<definitions>
  <definition term="dense_vector">
    Records dense vectors of float values.
  </definition>
  <definition term="sparse_vector">
    Records sparse vectors of float values.
  </definition>
  <definition term="rank_feature">
    Records a numeric feature to boost hits at query time.
  </definition>
  <definition term="rank_features">
    Records numeric features to boost hits at query time.
  </definition>
</definitions>


### Spatial data types

<definitions>
  <definition term="geo_point">
    Latitude and longitude points.
  </definition>
  <definition term="geo_shape">
    Complex shapes, such as polygons.
  </definition>
  <definition term="point">
    Arbitrary cartesian points.
  </definition>
  <definition term="shape">
    Arbitrary cartesian geometries.
  </definition>
</definitions>


### Other types

<definitions>
  <definition term="percolator">
    Indexes queries written in [Query DSL](https://www.elastic.co/docs/reference/query-languages/querydsl).
  </definition>
</definitions>


## Arrays

In Elasticsearch, arrays do not require a dedicated field data type. Any field can contain zero or more values by default, however, all values in the array must be of the same field type. See [Arrays](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/array).

## Multi-fields

It is often useful to index the same field in different ways for different purposes. For instance, a `string` field could be mapped as a `text` field for full-text search, and as a `keyword` field for sorting or aggregations. Alternatively, you could index a text field with the [`standard` analyzer](https://www.elastic.co/docs/reference/text-analysis/analysis-standard-analyzer), the [`english`](/docs/reference/text-analysis/analysis-lang-analyzer#english-analyzer) analyzer, and the [`french` analyzer](/docs/reference/text-analysis/analysis-lang-analyzer#french-analyzer).
This is the purpose of *multi-fields*. Most field types support multi-fields via the [`fields`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/multi-fields) parameter.