﻿---
title: enabled
description: Elasticsearch tries to index all of the fields you give it, but sometimes you want to just store the field without indexing it. For instance, imagine...
url: https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/enabled
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# enabled
Elasticsearch tries to index all of the fields you give it, but sometimes you want to just store the field without indexing it. For instance, imagine that you are using Elasticsearch as a web session store. You may want to index the session ID and last update time, but you don’t need to query or run aggregations on the session data itself.
The `enabled` setting, which can be applied only to the top-level mapping definition and to [`object`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/object) fields, causes Elasticsearch to skip parsing of the contents of the field entirely. The JSON can still be retrieved from the [`_source`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/mapping-source-field) field, but it is not searchable or stored in any other way:
```json

{
  "mappings": {
    "properties": {
      "user_id": {
        "type":  "keyword"
      },
      "last_updated": {
        "type": "date"
      },
      "session_data": { <1>
        "type": "object",
        "enabled": false
      }
    }
  }
}


{
  "user_id": "kimchy",
  "session_data": { <2>
    "arbitrary_object": {
      "some_array": [ "foo", "bar", { "baz": 2 } ]
    }
  },
  "last_updated": "2015-12-06T18:20:22"
}


{
  "user_id": "jpountz",
  "session_data": "none", <3>
  "last_updated": "2015-12-06T18:22:13"
}
```

The entire mapping may be disabled as well, in which case the document is stored in the [`_source`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/mapping-source-field) field, which means it can be retrieved, but none of its contents are indexed in any way:
```json

{
  "mappings": {
    "enabled": false <1>
  }
}


{
  "user_id": "kimchy",
  "session_data": {
    "arbitrary_object": {
      "some_array": [ "foo", "bar", { "baz": 2 } ]
    }
  },
  "last_updated": "2015-12-06T18:20:22"
}
```

The `enabled` setting for existing fields and the top-level mapping definition cannot be updated.
Note that because Elasticsearch completely skips parsing the field contents, it is possible to add non-object data to a disabled field:
```json

{
  "mappings": {
    "properties": {
      "session_data": {
        "type": "object",
        "enabled": false
      }
    }
  }
}


{
  "session_data": "foo bar" <1>
}
```