﻿---
title: dynamic
description: When you index a document containing a new field, Elasticsearch adds the field dynamically to a document or to inner objects within a document. The following...
url: https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/dynamic
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# dynamic
When you index a document containing a new field, Elasticsearch [adds the field dynamically](https://www.elastic.co/docs/manage-data/data-store/mapping/dynamic-mapping) to a document or to inner objects within a document. The following document adds the string field `username`, the object field `name`, and two string fields under the `name` object:
```json

{
  "username": "johnsmith",
  "name": { <1>
    "first": "John",
    "last": "Smith"
  }
}
```

The following document adds two string fields: `email` and `name.middle`:
```json

{
  "username": "marywhite",
  "email": "mary@white.com",
  "name": {
    "first": "Mary",
    "middle": "Alice",
    "last": "White"
  }
}
```


## Setting `dynamic` on inner objects

[Inner objects](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/object) inherit the `dynamic` setting from their parent object. In the following example, dynamic mapping is disabled at the type level, so no new top-level fields will be added dynamically.
However, the `user.social_networks` object enables dynamic mapping, so you can add fields to this inner object.
```json

{
  "mappings": {
    "dynamic": false, <1>
    "properties": {
      "user": { <2>
        "properties": {
          "name": {
            "type": "text"
          },
          "social_networks": {
            "dynamic": true, <3>
            "properties": {}
          }
        }
      }
    }
  }
}
```


## Parameters for `dynamic`

The `dynamic` parameter controls whether new fields are added dynamically, and accepts the following parameters:
<definitions>
  <definition term="true">
    New fields are added to the mapping (default).
  </definition>
  <definition term="runtime">
    New fields are added to the mapping as [runtime fields](https://www.elastic.co/docs/manage-data/data-store/mapping/runtime-fields). These fields are not indexed, and are loaded from `_source` at query time.
  </definition>
  <definition term="false">
    New fields are ignored. These fields will not be indexed or searchable, but will still appear in the `_source` field of returned hits. These fields will not be added to the mapping, and new fields must be added explicitly.
  </definition>
  <definition term="strict">
    If new fields are detected, an exception is thrown and the document is rejected. New fields must be explicitly added to the mapping.
  </definition>
</definitions>


## Behavior when reaching the field limit

Setting `dynamic` to either `true` or `runtime` will only add dynamic fields until `index.mapping.total_fields.limit` is reached. By default, index requests for documents that would exceed the field limit will fail, unless `index.mapping.total_fields.ignore_dynamic_beyond_limit` is set to `true`. In that case, ignored fields are added to the [`_ignored` metadata field](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/mapping-ignored-field). For more index setting details, refer to [Mapping limit settings](https://www.elastic.co/docs/reference/elasticsearch/index-settings/mapping-limit).