﻿---
title: Document metadata fields
description: Each document has metadata associated with it, such as the _index and _id metadata fields. The behavior of some of these metadata fields can be customized...
url: https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/document-metadata-fields
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Document metadata fields
Each document has metadata associated with it, such as the `_index` and `_id` metadata fields. The behavior of some of these metadata fields can be customized when a mapping is created.

## Identity metadata fields

<definitions>
  <definition term="_index">
    The index to which the document belongs.
  </definition>
  <definition term="_id">
    The document’s ID.
  </definition>
</definitions>


## Document source metadata fields

<definitions>
  <definition term="_source">
    The original JSON representing the body of the document.
  </definition>
  <definition term="_size">
    The size of the `_source` field in bytes, provided by the [`mapper-size` plugin](https://www.elastic.co/docs/reference/elasticsearch/plugins/mapper-size).
  </definition>
</definitions>


## Doc count metadata field

<definitions>
  <definition term="_doc_count">
    A custom field used for storing doc counts when a document represents pre-aggregated data.
  </definition>
</definitions>


## Indexing metadata fields

<definitions>
  <definition term="_field_names">
    All fields in the document which contain non-null values.
  </definition>
  <definition term="_ignored">
    All fields in the document that have been ignored at index time because of [`ignore_malformed`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/ignore-malformed).
  </definition>
</definitions>


## Routing metadata field

<definitions>
  <definition term="_routing">
    A custom routing value which routes a document to a particular shard.
  </definition>
</definitions>


## Other metadata field

<definitions>
  <definition term="_meta">
    Application specific metadata.
  </definition>
  <definition term="_tier">
    The current data tier preference of the index to which the document belongs.
  </definition>
</definitions>