﻿---
title: Date nanoseconds field type
description: This data type is an addition to the date data type. However there is an important distinction between the two. The existing date data type stores dates...
url: https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/date_nanos
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Date nanoseconds field type
This data type is an addition to the `date` data type. However there is an important distinction between the two. The existing `date` data type stores dates in millisecond resolution. The `date_nanos` data type stores dates in nanosecond resolution, which limits its range of dates from roughly 1970 to 2262, as dates are still stored as a long representing nanoseconds since the epoch.
Queries on nanoseconds are internally converted to range queries on this long representation, and the result of aggregations and stored fields is converted back to a string depending on the date format that is associated with the field.
Date formats can be customised, but if no `format` is specified then it uses the default:
```js
    "strict_date_optional_time_nanos||epoch_millis"
```

For instance:
```json

{
  "mappings": {
    "properties": {
      "date": {
        "type": "date_nanos" <1>
      }
    }
  }
}


{ "index" : { "_id" : "1" } }
{ "date": "2015-01-01" } <2>
{ "index" : { "_id" : "2" } }
{ "date": "2015-01-01T12:10:30.123456789Z" } <3>
{ "index" : { "_id" : "3" } }
{ "date": 1420070400000 } <4>


{
  "sort": { "date": "asc"}, <5>
  "runtime_mappings": {
    "date_has_nanos": {
      "type": "boolean",
      "script": "emit(doc['date'].value.nano != 0)" <6>
    }
  },
  "fields": [
    {
      "field": "date",
      "format": "strict_date_optional_time_nanos" <7>
    },
    {
      "field": "date_has_nanos"
    }
  ]
}
```

You can also specify multiple date formats separated by `||`. The same mapping parameters than with the `date` field can be used.
<warning>
  Date nanoseconds will accept numbers with a decimal point like `{"date": 1618249875.123456}` but there are some cases ([#70085](https://github.com/elastic/elasticsearch/issues/70085)) where we’ll lose precision on those dates so they should be avoided.
</warning>


## Limitations

Aggregations are still on millisecond resolution, even when using a `date_nanos` field. This limitation also affects [transforms](https://www.elastic.co/docs/explore-analyze/transforms).
<hr>

## Synthetic `_source`

Synthetic source may sort `date_nanos` field values. For example:

```json

{
  "settings": {
    "index": {
      "mapping": {
        "source": {
          "mode": "synthetic"
        }
      }
    }
  },
  "mappings": {
    "properties": {
      "date": { "type": "date_nanos" }
    }
  }
}

{
  "date": ["2015-01-01T12:10:30.000Z", "2014-01-01T12:10:30.000Z"]
}
```

Will become:
```json
{
  "date": ["2014-01-01T12:10:30.000Z", "2015-01-01T12:10:30.000Z"]
}
```