﻿---
title: copy_to
description: The copy_to parameter allows you to copy the values of multiple fields into a group field, which can then be queried as a single field. For example, the...
url: https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/copy-to
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# copy_to
The `copy_to` parameter allows you to copy the values of multiple fields into a group field, which can then be queried as a single field.
<tip>
  If you often search multiple fields, you can improve search speeds by using `copy_to` to search fewer fields. See [Search as few fields as possible](https://www.elastic.co/docs/deploy-manage/production-guidance/optimize-performance/search-speed#search-as-few-fields-as-possible).
</tip>

For example, the `first_name` and `last_name` fields can be copied to the `full_name` field as follows:
```json

{
  "mappings": {
    "properties": {
      "first_name": {
        "type": "text",
        "copy_to": "full_name" <1>
      },
      "last_name": {
        "type": "text",
        "copy_to": "full_name" <1>
      },
      "full_name": {
        "type": "text"
      }
    }
  }
}


{
  "first_name": "John",
  "last_name": "Smith"
}


{
  "query": {
    "match": {
      "full_name": { <2>
        "query": "John Smith",
        "operator": "and"
      }
    }
  }
}
```

Some important points:
- It is the field *value* which is copied, not the terms (which result from the analysis process).
- The original [`_source`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/mapping-source-field) field will not be modified to show the copied values.
- The same value can be copied to multiple fields, with `"copy_to": [ "field_1", "field_2" ]`
- You cannot copy recursively using intermediary fields. The following configuration will not copy data from `field_1` to `field_3`:
  ```json

  {
    "mappings": {
      "properties": {
        "field_1": {
          "type": "text",
          "copy_to": "field_2"
        },
        "field_2": {
          "type": "text",
          "copy_to": "field_3"
        },
        "field_3": {
          "type": "text"
        }
      }
    }
  }
  ```
  Instead, copy to multiple fields from the source field:
  ```json

  {
    "mappings": {
      "properties": {
        "field_1": {
          "type": "text",
          "copy_to": ["field_2", "field_3"]
        },
        "field_2": {
          "type": "text"
        },
        "field_3": {
          "type": "text"
        }
      }
    }
  }
  ```

<note>
  `copy_to` is not supported for field types where values take the form of objects, e.g. `date_range`.
</note>


## Dynamic mapping

Consider the following points when using `copy_to` with dynamic mappings:
- If the target field does not exist in the index mappings, the usual [dynamic mapping](https://www.elastic.co/docs/manage-data/data-store/mapping/dynamic-mapping) behavior applies. By default, with [`dynamic`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/dynamic) set to `true`, a non-existent target field will be dynamically added to the index mappings.
- If `dynamic` is set to `false`, the target field will not be added to the index mappings, and the value will not be copied.
- If `dynamic` is set to `strict`, copying to a non-existent field will result in an error.
- If the target field is nested, then `copy_to` fields must specify the full path to the nested field. Omitting the full path will lead to a `strict_dynamic_mapping_exception`. Use `"copy_to": ["parent_field.child_field"]` to correctly target a nested field.
  For example:
  ```json

  {
    "mappings": {
      "dynamic": "strict",
      "properties": {
        "description": {
          "properties": {
            "notes": {
              "type": "text",
              "copy_to": [ "description.notes_raw"], <1>
              "analyzer": "standard",
              "search_analyzer": "standard"
            },
            "notes_raw": {
              "type": "keyword"
            }
          }
        }
      }
    }
  }
  ```