﻿---
title: coerce
description: Data is not always clean. Depending on how it is produced a number might be rendered in the JSON body as a true JSON number, e.g. 5, but it might also...
url: https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/coerce
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# coerce
Data is not always clean. Depending on how it is produced a number might be rendered in the JSON body as a true JSON number, e.g. `5`, but it might also be rendered as a string, e.g. `"5"`. Alternatively, a number that should be an integer might instead be rendered as a floating point, e.g. `5.0`, or even `"5.0"`.
Coercion attempts to clean up dirty values to fit the data type of a field. For instance:
- Strings will be coerced to numbers.
- Floating points will be truncated for integer values.

For instance:
```json

{
  "mappings": {
    "properties": {
      "number_one": {
        "type": "integer"
      },
      "number_two": {
        "type": "integer",
        "coerce": false
      }
    }
  }
}


{
  "number_one": "10" <1>
}


{
  "number_two": "10" <2>
}
```

<tip>
  The `coerce` setting value can be updated on existing fields using the [update mapping API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-put-mapping).
</tip>


## Index-level default

The `index.mapping.coerce` setting can be set on the index level to disable coercion globally across all mapping types:
```json

{
  "settings": {
    "index.mapping.coerce": false
  },
  "mappings": {
    "properties": {
      "number_one": {
        "type": "integer",
        "coerce": true
      },
      "number_two": {
        "type": "integer"
      }
    }
  }
}


{ "number_one": "10" } <1>


{ "number_two": "10" } <2>
```