﻿---
title: Binary field type
description: The binary type accepts a binary value as a Base64 encoded string. The field is not stored by default and is not searchable: The following parameters...
url: https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/binary
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Binary field type
The `binary` type accepts a binary value as a [Base64](https://en.wikipedia.org/wiki/Base64) encoded string. The field is not stored by default and is not searchable:
```json

{
  "mappings": {
    "properties": {
      "name": {
        "type": "text"
      },
      "blob": {
        "type": "binary"
      }
    }
  }
}


{
  "name": "Some binary blob",
  "blob": "U29tZSBiaW5hcnkgYmxvYg==" <1>
}
```


## Parameters for `binary` fields

The following parameters are accepted by `binary` fields:
<definitions>
  <definition term="doc_values">
    Should the field be stored on disk in a column-stride fashion, so that it can later be used for sorting, aggregations, or scripting? Accepts `true` or `false` (default). This parameter will be automatically set to `true` for TSDB indices (indices that have `index.mode` set to `time_series`).
  </definition>
  <definition term="store">
    Whether the field value should be stored and retrievable separately from the [`_source`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/mapping-source-field) field. Accepts `true` or `false` (default).
  </definition>
</definitions>


## Synthetic `_source`

Synthetic source may sort `binary` values in order of their byte representation. For example:

```json

{
  "settings": {
    "index": {
      "mapping": {
        "source": {
          "mode": "synthetic"
        }
      }
    }
  },
  "mappings": {
    "properties": {
      "binary": { "type": "binary", "doc_values": true }
    }
  }
}

{
  "binary": ["IAA=", "EAA="]
}
```

Will become:
```json
{
  "binary": ["EAA=", "IAA="]
}
```