﻿---
title: analyzer
description: The analyzer parameter specifies the analyzer used for text analysis when indexing or searching a text field. Unless overridden with the search_analyzer...
url: https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/analyzer
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# analyzer
<important>
  Only [`text`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/text) fields support the `analyzer` mapping parameter.
</important>

The `analyzer` parameter specifies the [analyzer](https://www.elastic.co/docs/manage-data/data-store/text-analysis/anatomy-of-an-analyzer) used for [text analysis](https://www.elastic.co/docs/manage-data/data-store/text-analysis) when indexing or searching a `text` field.
Unless overridden with the [`search_analyzer`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/search-analyzer) mapping parameter, this analyzer is used for both [index and search analysis](https://www.elastic.co/docs/manage-data/data-store/text-analysis/index-search-analysis). See [Specify an analyzer](https://www.elastic.co/docs/manage-data/data-store/text-analysis/specify-an-analyzer).
<tip>
  We recommend testing analyzers before using them in production. See [Test an analyzer](https://www.elastic.co/docs/manage-data/data-store/text-analysis/test-an-analyzer).
</tip>

<tip>
  The `analyzer` setting can **not** be updated on existing fields using the [update mapping API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-put-mapping).
</tip>


## `search_quote_analyzer`

The `search_quote_analyzer` setting allows you to specify an analyzer for phrases, this is particularly useful when dealing with disabling stop words for phrase queries.
To disable stop words for phrases a field utilising three analyzer settings will be required:
1. An `analyzer` setting for indexing all terms including stop words
2. A `search_analyzer` setting for non-phrase queries that will remove stop words
3. A `search_quote_analyzer` setting for phrase queries that will not remove stop words

```json

{
   "settings":{
      "analysis":{
         "analyzer":{
            "my_analyzer":{ <1>
               "type":"custom",
               "tokenizer":"standard",
               "filter":[
                  "lowercase"
               ]
            },
            "my_stop_analyzer":{ <2>
               "type":"custom",
               "tokenizer":"standard",
               "filter":[
                  "lowercase",
                  "english_stop"
               ]
            }
         },
         "filter":{
            "english_stop":{
               "type":"stop",
               "stopwords":"_english_"
            }
         }
      }
   },
   "mappings":{
       "properties":{
          "title": {
             "type":"text",
             "analyzer":"my_analyzer", <3>
             "search_analyzer":"my_stop_analyzer", <4>
             "search_quote_analyzer":"my_analyzer" <5>
         }
      }
   }
}


{
   "title":"The Quick Brown Fox"
}


{
   "title":"A Quick Brown Fox"
}


{
   "query":{
      "query_string":{
         "query":"\"the quick brown fox\"" <6>
      }
   }
}
```