﻿---
title: Aggregate metric field type
description: Stores pre-aggregated numeric values for metric aggregations. An aggregate_metric_double field is an object containing one or more of the following metric...
url: https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/aggregate-metric-double
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Aggregate metric field type
Stores pre-aggregated numeric values for [metric aggregations](https://www.elastic.co/docs/reference/aggregations/metrics). An `aggregate_metric_double` field is an object containing one or more of the following metric sub-fields: `min`, `max`, `sum`, and `value_count`.
When you run certain metric aggregations on an `aggregate_metric_double` field, the aggregation uses the related sub-field’s values. For example, a [`min`](https://www.elastic.co/docs/reference/aggregations/search-aggregations-metrics-min-aggregation) aggregation on an `aggregate_metric_double` field returns the minimum value of all `min` sub-fields.
<important>
  An `aggregate_metric_double` field stores a single numeric [doc value](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/doc-values) for each metric sub-field. Array values are not supported. `min`, `max`, and `sum` values are `double` numbers. `value_count` is a positive `long` number.
</important>

```json

{
  "mappings": {
    "properties": {
      "my-agg-metric-field": {
        "type": "aggregate_metric_double",
        "metrics": [ "min", "max", "sum", "value_count" ],
        "default_metric": "max"
      }
    }
  }
}
```


## Parameters for `aggregate_metric_double` fields

<definitions>
  <definition term="metrics">
    (Required, array of strings) Array of metric sub-fields to store. Each value corresponds to a [metric aggregation](https://www.elastic.co/docs/reference/aggregations/metrics). Valid values are [`min`](https://www.elastic.co/docs/reference/aggregations/search-aggregations-metrics-min-aggregation), [`max`](https://www.elastic.co/docs/reference/aggregations/search-aggregations-metrics-max-aggregation), [`sum`](https://www.elastic.co/docs/reference/aggregations/search-aggregations-metrics-sum-aggregation), and [`value_count`](https://www.elastic.co/docs/reference/aggregations/search-aggregations-metrics-valuecount-aggregation). You must specify at least one value.
  </definition>
  <definition term="default_metric">
    (Required, string) Default metric sub-field to use for queries, scripts, and aggregations that don’t use a sub-field. Must be a value from the `metrics` array.
  </definition>
  <definition term="time_series_metric">
    (Optional, string) Marks the field as a [time series metric](https://www.elastic.co/docs/manage-data/data-store/data-streams/time-series-data-stream-tsds#time-series-metric). The value is the metric type. You can’t update this parameter for existing fields.
    **Valid `time_series_metric` values for `aggregate_metric_double` fields**:
    <definitions>
      <definition term="gauge">
        A metric that represents a single numeric that can arbitrarily increase or decrease. For example, a temperature or available disk space.
      </definition>
      <definition term="null (Default)">
        Not a time series metric.
      </definition>
    </definitions>
  </definition>
</definitions>


## Uses

We designed `aggregate_metric_double` fields for use with the following aggregations:
- A [`min`](https://www.elastic.co/docs/reference/aggregations/search-aggregations-metrics-min-aggregation) aggregation returns the minimum value of all `min` sub-fields.
- A [`max`](https://www.elastic.co/docs/reference/aggregations/search-aggregations-metrics-max-aggregation) aggregation returns the maximum value of all `max` sub-fields.
- A [`sum`](https://www.elastic.co/docs/reference/aggregations/search-aggregations-metrics-sum-aggregation) aggregation returns the sum of the values of all `sum` sub-fields.
- A [`value_count`](https://www.elastic.co/docs/reference/aggregations/search-aggregations-metrics-valuecount-aggregation) aggregation returns the sum of the values of all `value_count` sub-fields.
- A [`avg`](https://www.elastic.co/docs/reference/aggregations/search-aggregations-metrics-avg-aggregation) aggregation. There is no `avg` sub-field; the result of the `avg` aggregation is computed using the `sum` and `value_count` metrics. To run an `avg` aggregation, the field must contain both `sum` and `value_count` metric sub-field.

Running any other aggregation on an `aggregate_metric_double` field will fail with an "unsupported aggregation" error.
Finally, an `aggregate_metric_double` field supports the following queries for which it behaves as a `double` by delegating its behavior to its `default_metric` sub-field:
- [`exists`](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-exists-query)
- [`range`](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-range-query)
- [`term`](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-term-query)
- [`terms`](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-terms-query)


## Examples

The following [create index](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-create) API request creates an index with an `aggregate_metric_double` field named `agg_metric`. The request sets `max` as the field’s `default_metric`.
```json

{
  "mappings": {
    "properties": {
      "agg_metric": {
        "type": "aggregate_metric_double",
        "metrics": [ "min", "max", "sum", "value_count" ],
        "default_metric": "max"
      }
    }
  }
}
```

The following [index](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-create) API request adds documents with pre-aggregated data in the `agg_metric` field.
```json

{
  "agg_metric": {
    "min": -302.50,
    "max": 702.30,
    "sum": 200.0,
    "value_count": 25
  }
}


{
  "agg_metric": {
    "min": -93.00,
    "max": 1702.30,
    "sum": 300.00,
    "value_count": 25
  }
}
```

You can run `min`, `max`, `sum`, `value_count`, and `avg` aggregations on a `agg_metric` field.
```json

{
  "aggs": {
    "metric_min": { "min": { "field": "agg_metric" } },
    "metric_max": { "max": { "field": "agg_metric" } },
    "metric_value_count": { "value_count": { "field": "agg_metric" } },
    "metric_sum": { "sum": { "field": "agg_metric" } },
    "metric_avg": { "avg": { "field": "agg_metric" } }
  }
}
```

The aggregation results are based on related metric sub-field values.
```json
{
...
  "aggregations": {
    "metric_min": {
      "value": -302.5
    },
    "metric_max": {
      "value": 1702.3
    },
    "metric_value_count": {
      "value": 50
    },
    "metric_sum": {
      "value": 500.0
    },
    "metric_avg": {
      "value": 10.0
    }
  }
}
```

Queries on a `aggregate_metric_double` field use the `default_metric` value.
```json

{
  "query": {
    "term": {
      "agg_metric": {
        "value": 702.30
      }
    }
  }
}
```

The search returns the following hit. The value of the `default_metric` field, `max`, matches the query value.
```json
{
  ...
    "hits": {
    "total": {
      "value": 1,
      "relation": "eq"
    },
    "max_score": 1.0,
    "hits": [
      {
        "_index": "stats-index",
        "_id": "1",
        "_score": 1.0,
        "_source": {
          "agg_metric": {
            "min": -302.5,
            "max": 702.3,
            "sum": 200.0,
            "value_count": 25
          }
        }
      }
    ]
  }
}
```


## Synthetic `_source`

For example:

```json

{
  "settings": {
    "index": {
      "mapping": {
        "source": {
          "mode": "synthetic"
        }
      }
    }
  },
  "mappings": {
    "properties": {
      "agg_metric": {
        "type": "aggregate_metric_double",
        "metrics": [ "min", "max", "sum", "value_count" ],
        "default_metric": "max"
      }
    }
  }
}


{
  "agg_metric": {
    "min": -302.50,
    "max": 702.30,
    "sum": 200.0,
    "value_count": 25
  }
}
```

Will become:
```json
{
  "agg_metric": {
    "min": -302.50,
    "max": 702.30,
    "sum": 200.0,
    "value_count": 25
  }
}
```