﻿---
title: Total shards per node
description: The cluster-level shard allocator tries to spread the shards of a single index across as many nodes as possible. However, depending on how many shards...
url: https://www.elastic.co/docs/reference/elasticsearch/index-settings/total-shards-per-node
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Total shards per node
<admonition title="Settings supported in Serverless">
  Elastic Cloud Serverless projects [restrict the available Elasticsearch settings](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/differences-from-other-elasticsearch-offerings#elasticsearch-differences-serverless-settings-availability) to a supported subset, identified with a `Serverless` badge next to the setting name. For a complete list of available index settings, refer to the [Serverless index settings list](https://www.elastic.co/docs/reference/elasticsearch/index-settings/serverless).
</admonition>

The cluster-level shard allocator tries to spread the shards of a single index across as many nodes as possible. However, depending on how many shards and indices you have, and how big they are, it may not always be possible to spread shards evenly.
The following *dynamic* setting allows you to specify a hard limit on the total number of shards from a single index allowed per node:

<definitions>
  <definition term="index.routing.allocation.total_shards_per_node">
    The maximum number of shards (replicas and primaries) that will be allocated to a single node. Defaults to unbounded.
  </definition>
</definitions>

You can also limit the amount of shards a node can have regardless of the index:

<definitions>
  <definition term="cluster.routing.allocation.total_shards_per_node">
    ([Dynamic](https://www.elastic.co/docs/deploy-manage/stack-settings#dynamic-cluster-setting)) Maximum number of primary and replica shards allocated to each node. Defaults to `-1` (unlimited).
  </definition>
</definitions>

Elasticsearch checks this setting during shard allocation. For example, a cluster has a `cluster.routing.allocation.total_shards_per_node` setting of `100` and three nodes with the following shard allocations:
- Node A: 100 shards
- Node B: 98 shards
- Node C: 1 shard

If node C fails, Elasticsearch reallocates its shard to node B. Reallocating the shard to node A would exceed node A’s shard limit.
<warning>
  These settings impose a hard limit which can result in some shards not being allocated.Use with caution.
</warning>