﻿---
title: Time series index settings
description: Backing indices in a time series data stream (TSDS) support the following index settings. 
url: https://www.elastic.co/docs/reference/elasticsearch/index-settings/time-series
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Time series index settings
<admonition title="Settings supported in Serverless">
  Elastic Cloud Serverless projects [restrict the available Elasticsearch settings](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/differences-from-other-elasticsearch-offerings#elasticsearch-differences-serverless-settings-availability) to a supported subset, identified with a `Serverless` badge next to the setting name. For a complete list of available index settings, refer to the [Serverless index settings list](https://www.elastic.co/docs/reference/elasticsearch/index-settings/serverless).
</admonition>

Backing indices in a [time series data stream (TSDS)](https://www.elastic.co/docs/manage-data/data-store/data-streams/time-series-data-stream-tsds) support the following index settings.

<definitions>
  <definition term="index.mode Elastic Cloud Serverless: Generally available">
    (Static, string) Mode for the index. Valid values are [`time_series`](https://www.elastic.co/docs/manage-data/data-store/data-streams/time-series-data-stream-tsds) and `null` (no mode). Defaults to `null`.
  </definition>
</definitions>


<definitions>
  <definition term="index.time_series.start_time Elastic Cloud Serverless: Generally available">
    (Static, string) Earliest `@timestamp` value (inclusive) accepted by the index. Only indices with an `index.mode` of [`time_series`](https://www.elastic.co/docs/manage-data/data-store/data-streams/time-series-data-stream-tsds) support this setting. For more information, refer to [Time-bound indices](https://www.elastic.co/docs/manage-data/data-store/data-streams/time-series-data-stream-tsds).
  </definition>
</definitions>


<definitions>
  <definition term="index.time_series.end_time Elastic Cloud Serverless: Generally available">
    (Dynamic, string) Latest `@timestamp` value (exclusive) accepted by the index. Only indices with an `index.mode` of `time_series` support this setting. For more information, refer to [Time-bound indices](https://www.elastic.co/docs/manage-data/data-store/data-streams/time-series-data-stream-tsds).
  </definition>
</definitions>


<definitions>
  <definition term="index.look_ahead_time Elastic Cloud Serverless: Generally available">
    (Static, [time units](/docs/reference/elasticsearch/rest-apis/api-conventions#time-units)) Interval used to calculate the `index.time_series.end_time` for a TSDS’s write index. Defaults to `30m` (30 minutes). Accepts `1m` (one minute) to `2h` (two hours). Only indices with an `index.mode` of `time_series` support this setting. For more information, refer to [Look-ahead time](https://www.elastic.co/docs/manage-data/data-store/data-streams/time-series-data-stream-tsds). Additionally this setting can not be less than `time_series.poll_interval` cluster setting.
  </definition>
</definitions>

<note>
  Increasing the `look_ahead_time` will also increase the amount of time Index lifecycle management waits before being able to proceed with executing the actions that expect the index to not receive any writes anymore. For more information, refer to [Time-bound indices](https://www.elastic.co/docs/manage-data/data-store/data-streams/time-series-data-stream-tsds).
</note>


<definitions>
  <definition term="index.look_back_time Elastic Cloud Serverless: Generally available">
    (Static, [time units](/docs/reference/elasticsearch/rest-apis/api-conventions#time-units)) Interval used to calculate the `index.time_series.start_time` for a TSDS’s first backing index when a tsdb data stream is created. Defaults to `2h` (2 hours). Accepts `1m` (one minute) to `7d` (seven days). Only indices with an `index.mode` of `time_series` support this setting. For more information, refer to [Look-back time](https://www.elastic.co/docs/manage-data/data-store/data-streams/time-series-data-stream-tsds).
  </definition>
  <definition term="index.routing_path Elastic Cloud Serverless: Generally available">
    (Static, string or array of strings) Time series dimension fields used to route documents in a TSDS to index shards.
    Supports wildcards (`*`).
    Only indices with an `index.mode` of `time_series` support this setting.
  </definition>
  <definition term="Defaults value:">
  </definition>
  <definition term="Indices that are not part of a time series data stream have no default value and require the routing path to be defined explicitly.
  If a time series data stream is used that is eligible for the index.dimensions-based routing (see index.dimensions_tsid_strategy_enabled),
  the index.routing_path will be empty.
  For time series data streams where the index.dimensions-based routing does not apply,
  this defaults to the list of dimension fields with a time_series_dimension value of true as defined in your component and index templates.">
  </definition>
  <definition term="Manually setting a value disables the index.dimensions-based routing strategy (see index.dimensions_tsid_strategy_enabled).
  For more information, refer to Dimension-based routing.">
  </definition>
</definitions>


<definitions>
  <definition term="index.dimensions_tsid_strategy_enabled Elastic Stack: Generally available since 9.2 Elastic Cloud Serverless: Generally available">
    (Static, boolean) Controls if the `_tsid` can be created using the `index.dimensions` index setting.
    This is an internal setting that will be automatically populated and updated for eligible time series data streams and is not user-configurable.
    This strategy offers an improved ingestion performance that avoids processing dimensions multiple times for the purposes of shard routing and creating the `_tsid`.
    When used, `index.routing_path` will not be set and shard routing uses the full `_tsid`,
    which can help to avoid shard hot-spotting.
  </definition>
  <definition term="If set to false,
  or index.routing_path is configured manually,
  or in case the index isn't eligible (see below),
  shard routing will be based  on the index.routing_path instead.">
  </definition>
  <definition term="Defaults to true.">
  </definition>
  <definition term="This optimized _tsid creation strategy is only available for data streams and if there are no dynamic templates that set time_series_dimension: true.
  Trying to add such a dynamic template to existing backing indices after the fact will fail the update mapping request and you will need to roll over the data stream instead.">
  </definition>
</definitions>


<definitions>
  <definition term="index.mapping.dimension_fields.limit">
    (Dynamic, integer) Maximum number of [time series dimensions](https://www.elastic.co/docs/manage-data/data-store/data-streams/time-series-data-stream-tsds#time-series-dimension) for the index. Defaults to `32768`.
  </definition>
</definitions>