﻿---
title: Source index settings
description: All settings around the _source metadata field. index.source.mode : (Static, string) The source mode for the index. Valid values are synthetic, disabled...
url: https://www.elastic.co/docs/reference/elasticsearch/index-settings/source
products:
  - Elasticsearch
---

# Source index settings
All settings around the _source metadata field.

`index.source.mode`
: (Static, string) The source mode for the index. Valid values are [`synthetic`](/docs/reference/elasticsearch/mapping-reference/mapping-source-field#synthetic-source), [`disabled`](/docs/reference/elasticsearch/mapping-reference/mapping-source-field#disable-source-field) or `stored`. Defaults to `stored`. The `stored` source mode always stores the source metadata field on disk.

`index.recovery.use_synthetic_source`
: (Static, boolean) If synthetic source mode is used, whether the recovery source should also be synthesized instead of stored to disk. Defaults to `true`. This setting can only be configured if synthetic source mode is enabled.

`index.mapping.synthetic_source_keep`
: (Static, string) Controls how to retain accuracy of fields at the index level. Valid values are `none` or `arrays`.This is a subset of [synthetic source keep mapping attribute](/docs/reference/elasticsearch/mapping-reference/mapping-source-field#synthetic-source-keep). Defaults to `arrays` if `index.mode` is `logsdb` or otherwise `none`.