﻿---
title: Slow log settings
description: The slow log in Elasticsearch helps you capture search or indexing operations that exceed certain durations, which can be useful when diagnosing slow...
url: https://www.elastic.co/docs/reference/elasticsearch/index-settings/slow-log
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Slow log settings
<admonition title="Settings supported in Serverless">
  Elastic Cloud Serverless projects [restrict the available Elasticsearch settings](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/differences-from-other-elasticsearch-offerings#elasticsearch-differences-serverless-settings-availability) to a supported subset, identified with a `Serverless` badge next to the setting name. For a complete list of available index settings, refer to the [Serverless index settings list](https://www.elastic.co/docs/reference/elasticsearch/index-settings/serverless).
</admonition>

The slow log in Elasticsearch helps you capture search or indexing operations that exceed certain durations, which can be useful when diagnosing slow performance or indexing bottlenecks. For more information about slow log formats and how to enable slow logs, refer to [Slow query and index logging](https://www.elastic.co/docs/deploy-manage/monitor/logging-configuration/slow-logs).
Slow logs are emitted under `fileset.name = "slowlog"`, logger names `index.search.slowlog` or `index.indexing.slowlog`.
By default, all thresholds default to `-1`, which disables slow logging.

## Settings for search operations

Search slow logs emit per shard. They must be enabled separately for the shard’s [query and fetch search phases](https://www.elastic.co/blog/understanding-query-then-fetch-vs-dfs-query-then-fetch).
<definitions>
  <definition term="index.search.slowlog.threshold.query.<level>">
    Sets the minimum threshold for logging slow query-phase operations. `<level>` can be `warn`, `info`, `debug`, and `trace`. The threshold value accepts a string format that specifies a number and a unit of measurement such as `ms`, `s`, or any [other accepted increments](/docs/reference/elasticsearch/rest-apis/api-conventions#time-units). When a query takes longer than the configured value, a slow log entry is emitted.
    <dropdown title="Example">
      The following request enables slow logs by configuring thresholds:
      ```json
      {
        "index.search.slowlog.threshold.query.warn": "10s",
        "index.search.slowlog.threshold.query.info": "5s",
        "index.search.slowlog.threshold.query.debug": "2s",
        "index.search.slowlog.threshold.query.trace": "500ms"
      }
      ```
    </dropdown>
  </definition>
  <definition term="index.search.slowlog.threshold.fetch.<level>">
    Sets the minimum threshold for logging slow fetch-phase operations (retrieving documents after query hits). `<level>` can be `warn`, `info`, `debug`, and `trace`. The threshold value accepts a string format that specifies a number and a unit of measurement such as `ms`, `s`, or any [other accepted increments](/docs/reference/elasticsearch/rest-apis/api-conventions#time-units). When fetching takes longer than the configured value, a slow log entry is emitted.
    <dropdown title="Example">
      The following request enables slow logs by configuring thresholds:
      ```json
      {
        "index.search.slowlog.threshold.fetch.warn": "1s",
        "index.search.slowlog.threshold.fetch.info": "800ms",
        "index.search.slowlog.threshold.fetch.debug": "500ms",
        "index.search.slowlog.threshold.fetch.trace": "200ms"
      }
      ```
    </dropdown>
  </definition>
  <definition term="index.search.slowlog.include.user">
    This setting accepts a boolean value. If set to `true`, it includes `user.*` and `auth.type` metadata in the log entries. These fields contain information about the user who triggered the request.
    <dropdown title="Example">
      The following request enables slow logs and includes information about who triggered the request:
      ```json
      {
        "index.search.slowlog.threshold.query.warn": "10s",
        "index.search.slowlog.threshold.query.info": "5s",
        "index.search.slowlog.threshold.query.debug": "2s",
        "index.search.slowlog.threshold.query.trace": "500ms",
        "index.search.slowlog.threshold.fetch.warn": "1s",
        "index.search.slowlog.threshold.fetch.info": "800ms",
        "index.search.slowlog.threshold.fetch.debug": "500ms",
        "index.search.slowlog.threshold.fetch.trace": "200ms",
        "index.search.slowlog.include.user": true
      }
      ```
    </dropdown>
  </definition>
</definitions>


## Settings for indexing operations

Indexing slow logs emit per index document.
<definitions>
  <definition term="index.indexing.slowlog.threshold.index.<level>">
    Sets the minimum threshold for logging slow indexing operations. `<level>` can be `warn`, `info`, `debug`, and `trace`. The threshold value accepts a string format that specifies a number and a unit of measurement such as `ms`, `s`, or any [other accepted increments](/docs/reference/elasticsearch/rest-apis/api-conventions#time-units). When an indexing operation takes longer than the configured value, a slow log entry is emitted.
    <dropdown title="Example">
      The following request enables slow logs by configuring thresholds:
      ```json
      {
        "index.indexing.slowlog.threshold.index.warn": "10s",
        "index.indexing.slowlog.threshold.index.info": "5s",
        "index.indexing.slowlog.threshold.index.debug": "2s",
        "index.indexing.slowlog.threshold.index.trace": "500ms"
      }
      ```
    </dropdown>
  </definition>
  <definition term="index.indexing.slowlog.include.user">
    This setting accepts a boolean value. If set to `true`, it includes `user.*` and `auth.type` metadata in the log entries. These fields contain information about the user who initiated the request.
    <dropdown title="Example">
      The following request enables slow logs by configuring thresholds and includes information about who triggered the request:
      ```json
      {
        "index.indexing.slowlog.threshold.index.warn": "10s",
        "index.indexing.slowlog.threshold.index.info": "5s",
        "index.indexing.slowlog.threshold.index.debug": "2s",
        "index.indexing.slowlog.threshold.index.trace": "500ms",
        "index.indexing.slowlog.include.user": true
      }
      ```
    </dropdown>
  </definition>
  <definition term="index.indexing.slowlog.source">
    Sets the number of `_source` characters to include. By default, Elasticsearch logs the first 1000 characters in the slow log. Set to `false`or `0` to disable source logging. Set to `true` to log the entire source regardless of size.
    <dropdown title="Example">
      The following request enables slow logs by configuring thresholds and setting the number of `_source` characters to include to 3000, rather than the default of 1000:
      ```json
      {
        "index.indexing.slowlog.threshold.index.warn": "10s",
        "index.indexing.slowlog.threshold.index.info": "5s",
        "index.indexing.slowlog.threshold.index.debug": "2s",
        "index.indexing.slowlog.threshold.index.trace": "500ms",
        "index.indexing.slowlog.include.user": true,
        "index.indexing.slowlog.source": "3000"
      }
      ```
    </dropdown>
  </definition>
  <definition term="index.indexing.slowlog.reformat">
    This setting accepts a boolean value. It's set to `true` by default and reformats the original `_source` into a single-line log entry. If you want to preserve the original document format, then you can turn off reformatting by setting it to `false`. This causes source to be logged with the original formatting intact, potentially spanning multiple log lines.
    <dropdown title="Example">
      The following request enables slow logs by configuring thresholds and includes reformatting the `_source` into a single-line entry:
      ```json
      {
        "index.indexing.slowlog.threshold.index.warn": "10s",
        "index.indexing.slowlog.threshold.index.info": "5s",
        "index.indexing.slowlog.threshold.index.debug": "2s",
        "index.indexing.slowlog.threshold.index.trace": "500ms",
        "index.indexing.slowlog.include.user": true,
        "index.indexing.slowlog.source": "3000",
        "index.indexing.slowlog.reformat": true
      }
      ```
    </dropdown>
  </definition>
</definitions>