﻿---
title: Index settings available in Elastic Cloud Serverless projects
description: In Elastic Cloud Serverless projects, configuration available to users is limited to certain index-level settings. These restrictions help ensure the...
url: https://www.elastic.co/docs/reference/elasticsearch/index-settings/serverless
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
---

# Index settings available in Elastic Cloud Serverless projects
In Elastic Cloud Serverless projects, configuration available to users is [limited](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/differences-from-other-elasticsearch-offerings#elasticsearch-differences-serverless-settings-availability) to certain index-level settings. These restrictions help ensure the reliability of Serverless projects.
This page lists the Elasticsearch index settings available in Elastic Cloud Serverless projects.

### General settings

- [`index.codec`](/docs/reference/elasticsearch/index-settings/index-modules#index-codec)
- [`index.default_pipeline`](/docs/reference/elasticsearch/index-settings/index-modules#index-default-pipeline)
- [`index.dense_vector.hnsw_filter_heuristic`](/docs/reference/elasticsearch/index-settings/index-modules#index-dense-vector-hnsw-filter-heuristic)
- [`index.final_pipeline`](/docs/reference/elasticsearch/index-settings/index-modules#index-final-pipeline)
- [`index.hidden`](/docs/reference/elasticsearch/index-settings/index-modules#index-hidden)
- [`index.mode`](/docs/reference/elasticsearch/index-settings/index-modules#index-mode-setting)
- [`index.query.default_field`](/docs/reference/elasticsearch/index-settings/index-modules#index-query-default-field)
- [`index.refresh_interval`](/docs/reference/elasticsearch/index-settings/index-modules#index-refresh-interval-setting)


### Index sorting settings

- [`index.sort.field`](/docs/reference/elasticsearch/index-settings/sorting#index-sort-field)
- [`index.sort.missing`](/docs/reference/elasticsearch/index-settings/sorting#index-sort-missing)
- [`index.sort.mode`](/docs/reference/elasticsearch/index-settings/sorting#index-sort-mode)
- [`index.sort.order`](/docs/reference/elasticsearch/index-settings/sorting#index-sort-order)


### Index blocks settings

- [`index.blocks.read_only`](/docs/reference/elasticsearch/index-settings/index-block#index-blocks-read-only)
- [`index.blocks.read`](/docs/reference/elasticsearch/index-settings/index-block#index-blocks-read)
- [`index.blocks.write`](/docs/reference/elasticsearch/index-settings/index-block#index-blocks-write)
- [`index.blocks.metadata`](/docs/reference/elasticsearch/index-settings/index-block#index-blocks-metadata)


### Field and mapping related settings

- [`index.mapping.coerce`](/docs/reference/elasticsearch/mapping-reference/coerce#coerce-setting)
- [`index.mapping.ignore_above`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/index-mapping-ignore-above)
- [`index.mapping.ignore_malformed`](/docs/reference/elasticsearch/mapping-reference/ignore-malformed#ignore-malformed-setting)
- [`index.mapping.source.mode`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/mapping-source-field)
- [`index.mapping.synthetic_source_keep`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/mapping-source-field)
- [`index.mapping.total_fields.limit`](/docs/reference/elasticsearch/index-settings/mapping-limit#total-fields-limit)
- [`index.mapping.total_fields.ignore_dynamic_beyond_limit`](/docs/reference/elasticsearch/index-settings/mapping-limit#ignore-dynamic-beyond-limit)


### Data stream lifecycle settings

- [`index.lifecycle.origination_date`](/docs/reference/elasticsearch/configuration-reference/data-stream-lifecycle-settings#index-data-stream-lifecycle-origination-date)


### Time series settings

- [`index.time_series.start_time`](/docs/reference/elasticsearch/index-settings/time-series#index-time-series-start-time)
- [`index.time_series.end_time`](/docs/reference/elasticsearch/index-settings/time-series#index-time-series-end-time)
- [`index.look_ahead_time`](/docs/reference/elasticsearch/index-settings/time-series#index-look-ahead-time)
- [`index.look_back_time`](/docs/reference/elasticsearch/index-settings/time-series#index-look-back-time)
- [`index.routing_path`](/docs/reference/elasticsearch/index-settings/time-series#index-routing-path)
- [`index.dimensions_tsid_strategy_enabled`](/docs/reference/elasticsearch/index-settings/time-series#index-dimensions-tsid-strategy-enabled)


### Similarity and analyzers

- [`index.similarity.*`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/similarity)
- [`index.analysis.*`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/analyzer)