﻿---
title: Index recovery prioritization settings
description: Unallocated shards are recovered in order of priority, whenever possible. Indices are sorted into priority order as follows: the optional index.priority...
url: https://www.elastic.co/docs/reference/elasticsearch/index-settings/recovery-prioritization
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Index recovery prioritization settings
<admonition title="Settings supported in Serverless">
  Elastic Cloud Serverless projects [restrict the available Elasticsearch settings](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/differences-from-other-elasticsearch-offerings#elasticsearch-differences-serverless-settings-availability) to a supported subset, identified with a `Serverless` badge next to the setting name. For a complete list of available index settings, refer to the [Serverless index settings list](https://www.elastic.co/docs/reference/elasticsearch/index-settings/serverless).
</admonition>

Unallocated shards are recovered in order of priority, whenever possible. Indices are sorted into priority order as follows:
- the optional `index.priority` setting (higher before lower)
- the index creation date (higher before lower)
- the index name (higher before lower)

This means that, by default, newer indices will be recovered before older indices.
Use the per-index dynamically updatable `index.priority` setting to customise the index prioritization order. For instance:
```json





{
  "settings": {
    "index.priority": 10
  }
}


{
  "settings": {
    "index.priority": 5
  }
}
```

In the above example:
- `index_3` will be recovered first because it has the highest `index.priority`.
- `index_4` will be recovered next because it has the next highest priority.
- `index_2` will be recovered next because it was created more recently.
- `index_1` will be recovered last.

This setting accepts an integer, and can be updated on a live index with the [update index settings API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-put-settings):
```json

{
  "index.priority": 1
}
```