﻿---
title: Index blocks
description: Index blocks limit the kind of operations that are available on a certain index. The blocks come in different flavours, allowing to block write, read,...
url: https://www.elastic.co/docs/reference/elasticsearch/index-settings/index-block
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Index blocks
<admonition title="Settings supported in Serverless">
  Elastic Cloud Serverless projects [restrict the available Elasticsearch settings](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/differences-from-other-elasticsearch-offerings#elasticsearch-differences-serverless-settings-availability) to a supported subset, identified with a `Serverless` badge next to the setting name. For a complete list of available index settings, refer to the [Serverless index settings list](https://www.elastic.co/docs/reference/elasticsearch/index-settings/serverless).
</admonition>

Index blocks limit the kind of operations that are available on a certain index. The blocks come in different flavours, allowing to block write, read, or metadata operations. The blocks can be set / removed using dynamic index settings, or can be added using a dedicated API, which also ensures for write blocks that, once successfully returning to the user, all shards of the index are properly accounting for the block, for example that all in-flight writes to an index have been completed after adding the write block.

## Index block settings

The following *dynamic* index settings determine the blocks present on an index:

<definitions>
  <definition term="index.blocks.read_only Elastic Cloud Serverless: Generally available">
    Set to `true` to make the index and index metadata read only, `false` to allow writes and metadata changes.
  </definition>
  <definition term="index.blocks.read_only_allow_delete">
    Similar to `index.blocks.write`, except that you can delete the index when this block is in place. Do not set or remove this block yourself. The [disk-based shard allocator](/docs/reference/elasticsearch/configuration-reference/cluster-level-shard-allocation-routing-settings#disk-based-shard-allocation) sets and removes this block automatically according to the available disk space.
    Deleting documents from an index to release resources - rather than deleting the index itself - increases the index size temporarily, and therefore may not be possible when nodes are low on disk space. When `index.blocks.read_only_allow_delete` is set to `true`, deleting documents is not permitted. However, deleting the index entirely requires very little extra disk space and frees up the disk space consumed by the index almost immediately so this is still permitted.
    <important>
      Elasticsearch adds the read-only-allow-delete index block automatically when the disk utilization exceeds the flood stage watermark, and removes this block automatically when the disk utilization falls under the high watermark. See [Disk-based shard allocation](/docs/reference/elasticsearch/configuration-reference/cluster-level-shard-allocation-routing-settings#disk-based-shard-allocation) for more information about watermarks, and [Fix watermark errors](https://www.elastic.co/docs/troubleshoot/elasticsearch/fix-watermark-errors) for help with resolving watermark issues.
    </important>
  </definition>
  <definition term="">
    Set to `true` to disable read operations against the index.
  </definition>
</definitions>


<definitions>
  <definition term="index.blocks.write Elastic Cloud Serverless: Generally available">
    Set to `true` to disable data write operations against the index. Unlike `read_only`, this setting does not affect metadata. For instance, you can adjust the settings of an index with a `write` block, but you cannot adjust the settings of an index with a `read_only` block.
  </definition>
  <definition term="">
    Set to `true` to disable index metadata reads and writes.
  </definition>
</definitions>