﻿---
title: Data tier allocation settings
description: You can use the index-level _tier_preference setting to control which data tier an index is allocated to. This setting corresponds to the data node roles:...
url: https://www.elastic.co/docs/reference/elasticsearch/index-settings/data-tier-allocation
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Data tier allocation settings
<admonition title="Settings supported in Serverless">
  Elastic Cloud Serverless projects [restrict the available Elasticsearch settings](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/differences-from-other-elasticsearch-offerings#elasticsearch-differences-serverless-settings-availability) to a supported subset, identified with a `Serverless` badge next to the setting name. For a complete list of available index settings, refer to the [Serverless index settings list](https://www.elastic.co/docs/reference/elasticsearch/index-settings/serverless).
</admonition>

You can use the index-level `_tier_preference` setting to control which [data tier](https://www.elastic.co/docs/manage-data/lifecycle/data-tiers) an index is allocated to.
This setting corresponds to the data node roles:
- [data_content](https://www.elastic.co/docs/deploy-manage/distributed-architecture/clusters-nodes-shards/node-roles#data-content-node)
- [data_hot](https://www.elastic.co/docs/deploy-manage/distributed-architecture/clusters-nodes-shards/node-roles#data-hot-node)
- [data_warm](https://www.elastic.co/docs/deploy-manage/distributed-architecture/clusters-nodes-shards/node-roles#data-warm-node)
- [data_cold](https://www.elastic.co/docs/deploy-manage/distributed-architecture/clusters-nodes-shards/node-roles#data-cold-node)
- [data_frozen](https://www.elastic.co/docs/deploy-manage/distributed-architecture/clusters-nodes-shards/node-roles#data-frozen-node)

<note>
  The [data](https://www.elastic.co/docs/deploy-manage/distributed-architecture/clusters-nodes-shards/node-roles#data-node-role) role is not a valid data tier and cannot be used with the `_tier_preference` setting. The frozen tier stores [partially mounted indices](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/searchable-snapshots#partially-mounted) exclusively.
</note>


## Data tier allocation settings


<definitions>
  <definition term="index.routing.allocation.include._tier_preference">
    Assign the index to the first tier in the list that has an available node. This prevents indices from remaining unallocated if no nodes are available in the preferred tier. For example, if you set `index.routing.allocation.include._tier_preference` to `data_warm,data_hot`, the index is allocated to the warm tier if there are nodes with the `data_warm` role. If there are no nodes in the warm tier, but there are nodes with the `data_hot` role, the index is allocated to the hot tier. Used in conjunction with [data tiers](https://www.elastic.co/docs/manage-data/lifecycle/data-tiers#data-tier-allocation).
  </definition>
</definitions>