﻿---
title: Index settings
description: Elasticsearch organizes index-level settings into index modules, each controlling a specific aspect of index behavior. These settings are configured...
url: https://www.elastic.co/docs/reference/elasticsearch/index-settings
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Index settings
<admonition title="Settings supported in Serverless">
  Elastic Cloud Serverless projects [restrict the available Elasticsearch settings](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/differences-from-other-elasticsearch-offerings#elasticsearch-differences-serverless-settings-availability) to a supported subset, identified with a `Serverless` badge next to the setting name. For a complete list of available index settings, refer to the [Serverless index settings list](https://www.elastic.co/docs/reference/elasticsearch/index-settings/serverless).
</admonition>


Elasticsearch organizes index-level settings into index modules, each controlling a specific aspect of index behavior.
These settings are configured on a per-index basis and may be:
- _Static_
  They can only be set at index creation time or on a closed index, or by using the [update index settings API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-put-settings) with the `reopen` query parameter set to `true` (which automatically closes and reopens impacted indices).
- _Dynamic_
  They can be changed on a live index using the [update index settings API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-put-settings).

<warning>
  You can change any documented index settings on closed indices. However, changing undocumented index settings on closed indices is unsupported and might result in errors.
</warning>

Settings are available for the following modules:
- [General](https://www.elastic.co/docs/reference/elasticsearch/index-settings/index-modules):
  Index settings not tied to a specific module.
- [Index shard allocation](https://www.elastic.co/docs/reference/elasticsearch/index-settings/shard-allocation):
  Control where, when, and how shards are allocated to nodes.
- [History retention](https://www.elastic.co/docs/reference/elasticsearch/index-settings/history-retention)
  Control how long the history of operations is retained in the index.
- [Index blocks](https://www.elastic.co/docs/reference/elasticsearch/index-settings/index-block):
  Block different type of operations to the indices.
- [Mapping limits](https://www.elastic.co/docs/reference/elasticsearch/index-settings/mapping-limit):
  Limit the number of field mappings.
- [Merge](https://www.elastic.co/docs/reference/elasticsearch/index-settings/merge):
  Control how shards are merged by the background merge process.
- [Similarities](https://www.elastic.co/docs/reference/elasticsearch/index-settings/similarity):
  Configure custom similarity settings to customize how search results are scored.
- [Slowlog](https://www.elastic.co/docs/reference/elasticsearch/index-settings/slow-log):
  Control how slow queries and fetch requests are logged.
- [Sorting](https://www.elastic.co/docs/reference/elasticsearch/index-settings/sorting):
  Configure how to sort the segments inside each shard.
- [Store](https://www.elastic.co/docs/reference/elasticsearch/index-settings/store):
  Configure the type of filesystem used to access shard data.
- [Time series](https://www.elastic.co/docs/reference/elasticsearch/index-settings/time-series)
  Configure the backing indices in a time series data stream (TSDS).
- [Translog](https://www.elastic.co/docs/reference/elasticsearch/index-settings/translog)
  Control the transaction log and background flush operations.
- [Indexing pressure](https://www.elastic.co/docs/reference/elasticsearch/index-settings/pressure)
  Configure indexing back pressure limits.

There are also index settings associated with [text analysis](https://www.elastic.co/docs/manage-data/data-store/text-analysis), which define analyzers, tokenizers, token filters, and character filters.