﻿---
title: Wait for snapshot
description: Phases allowed: delete. Waits for the specified SLM policy to be executed before removing the index. This ensures that a snapshot of the deleted index...
url: https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-wait-for-snapshot
products:
  - Elasticsearch
---

# Wait for snapshot
Phases allowed: delete.
Waits for the specified SLM policy to be executed before removing the index. This ensures that a snapshot of the deleted index is available.

## Options

<definitions>
  <definition term="policy">
    (Required, string) Name of the SLM policy that the delete action should wait for.
  </definition>
</definitions>


## Example

```json

{
  "policy": {
    "phases": {
      "delete": {
        "actions": {
          "wait_for_snapshot" : {
            "policy": "slm-policy-name"
          }
        }
      }
    }
  }
}
```