﻿---
title: Searchable snapshot
description: Phases allowed: hot, cold, frozen. Takes a snapshot of the managed index in the configured repository and mounts it as a searchable snapshot. If the index...
url: https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-searchable-snapshot
products:
  - Elasticsearch
---

# Searchable snapshot
Phases allowed: hot, cold, frozen.
Takes a snapshot of the managed index in the configured repository and mounts it as a [searchable snapshot](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/searchable-snapshots). If the index is part of a [data stream](https://www.elastic.co/docs/manage-data/data-store/data-streams), the mounted index replaces the original index in the stream.
The `searchable_snapshot` action requires [data tiers](https://www.elastic.co/docs/manage-data/lifecycle/data-tiers). The action uses the [`index.routing.allocation.include._tier_preference`](/docs/reference/elasticsearch/index-settings/data-tier-allocation#tier-preference-allocation-filter) setting to mount the index directly to the phase’s corresponding data tier. In the frozen phase, the action mounts a [partially mounted index](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/searchable-snapshots#partially-mounted) prefixed with `partial-` to the frozen tier. In other phases, the action mounts a [fully mounted index](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/searchable-snapshots#fully-mounted) prefixed with `restored-` to the corresponding data tier.
In the frozen tier, the action will ignore the setting [`index.routing.allocation.total_shards_per_node`](/docs/reference/elasticsearch/index-settings/total-shards-per-node#total-shards-per-node), if it was present in the original index, to account for the difference in the number of nodes between the frozen and the other tiers. To set [`index.routing.allocation.total_shards_per_node`](/docs/reference/elasticsearch/index-settings/total-shards-per-node#total-shards-per-node) for searchable snapshots, set the `total_shards_per_node` option in the frozen phase’s `searchable_snapshot` action within the ILM policy.
<warning>
  Don’t include the `searchable_snapshot` action in both the hot and cold phases. This can result in indices failing to automatically migrate to the cold tier during the cold phase.
</warning>

If the `searchable_snapshot` action is used in the hot phase the subsequent phases cannot include the `shrink` or `forcemerge` actions.
This action cannot be performed on a data stream’s write index. Attempts to do so will fail. To convert the index to a searchable snapshot, first [manually roll over](https://www.elastic.co/docs/manage-data/data-store/data-streams/use-data-stream#manually-roll-over-a-data-stream) the data stream. This creates a new write index. Because the index is no longer the stream’s write index, the action can then convert it to a searchable snapshot. Using a policy that makes use of the [rollover](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-rollover) action in the hot phase will avoid this situation and the need for a manual rollover for future managed indices.
<important>
  Mounting and relocating the shards of searchable snapshot indices involves copying the shard contents from the snapshot repository. This may incur different costs from the copying between nodes that happens with regular indices. These costs are typically lower but, in some environments, may be higher. See [Reduce costs with searchable snapshots](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/searchable-snapshots#searchable-snapshots-costs) for more details.
</important>

By default, this snapshot is deleted by the [delete action](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-delete) in the delete phase. To keep the snapshot, set `delete_searchable_snapshot` to `false` in the delete action. This snapshot retention runs off the index lifecycle management (ILM) policies and is not effected by snapshot lifecycle management (SLM) policies.

## Options

<definitions>
  <definition term="snapshot_repository">
    (Required, string) [Repository](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/self-managed) used to store the snapshot.
  </definition>
  <definition term="replicate_for">
    (Optional, TimeValue) By default, searchable snapshot indices are mounted without replicas. Using this will result in a searchable snapshot index being mounted with a single replica for the time period specified, after which the replica will be removed. This option is only permitted on the first searchable snapshot action of a policy.
  </definition>
  <definition term="force_merge_index">
    (Optional, Boolean) Force merges the managed index to one segment. Defaults to `true`. If the managed index was already force merged using the [force merge action](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-forcemerge) in a previous action the `searchable snapshot` action force merge step will be a no-op.
    <note>
      Shards that are relocating during a `forcemerge` will not be merged. The `searchable_snapshot` action will continue executing even if not all shards are force merged.
    </note>
    This force merging occurs in the phase that the index is in **prior** to the `searchable_snapshot` action. For example, if using a `searchable_snapshot` action in the `hot` phase, the force merge will be performed on the hot nodes. If using a `searchable_snapshot` action in the `cold` phase, the force merge will be performed on whatever tier the index is **prior** to the `cold` phase (either `hot` or `warm`).
  </definition>
  <definition term="force_merge_on_clone Elastic Stack: Generally available since 9.2">
    (Optional, Boolean) By default, if `force_merge_index` is `true`, the index will first be cloned with 0 replicas and the force-merge will be performed on the clone before the searchable snapshot is created. This avoids performing the force-merge redundantly on replica shards, as the snapshot operation only uses primary shards. Setting this option to `false` will skip the clone step and perform the force-merge directly on the managed index. Defaults to `true`.
  </definition>
  <definition term="total_shards_per_node">
    (Optional, Integer) The maximum number of shards (replicas and primaries) that will be allocated to a single node for the searchable snapshot index. Defaults to unbounded.
  </definition>
</definitions>


## Examples

```json

{
  "policy": {
    "phases": {
      "cold": {
        "actions": {
          "searchable_snapshot" : {
            "snapshot_repository" : "backing_repo"
          }
        }
      }
    }
  }
}
```


### Mount a searchable snapshot with replicas for fourteen days

This policy mounts a searchable snapshot in the hot phase with a single replica and maintains that replica for fourteen days. After that time has elapsed, the searchable snapshot index will remain (with no replicas) for another fourteen days, at which point it will proceed into the delete phase and will be deleted.
```json

{
  "policy": {
    "phases": {
      "hot": {
        "actions": {
          "rollover" : {
            "max_primary_shard_size": "50gb"
          },
          "searchable_snapshot" : {
            "snapshot_repository" : "backing_repo",
            "replicate_for": "14d"
          }
        }
      },
      "delete": {
        "min_age": "28d",
        "actions": {
          "delete" : { }
        }
      }
    }
  }
}
```

<note>
  If the `replicate_for` option is specified, its value must be less than the minimum age of the next phase in the policy.
</note>