﻿---
title: Read only
description: Phases allowed: hot, warm, cold. Makes the index data read-only; disables data write operations against the index. To use the readonly action in the hot...
url: https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-readonly
products:
  - Elasticsearch
---

# Read only
Phases allowed: hot, warm, cold.
Makes the index data read-only; disables data write operations against the index.
To use the `readonly` action in the `hot` phase, the `rollover` action **must** be present. If no rollover action is configured, ILM will reject the policy.

## Options

None.

## Example

```json

{
  "policy": {
    "phases": {
      "warm": {
        "actions": {
          "readonly" : { }
        }
      }
    }
  }
}
```