﻿---
title: Migrate
description: Phases allowed: warm, cold. Moves the index to the data tier that corresponds to the current phase by updating the index.routing.allocation.include._tier_preference...
url: https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-migrate
products:
  - Elasticsearch
---

# Migrate
Phases allowed: warm, cold.
Moves the index to the [data tier](https://www.elastic.co/docs/manage-data/lifecycle/data-tiers) that corresponds to the current phase by updating the `index.routing.allocation.include._tier_preference` index setting. ILM automatically injects the migrate action in the warm and cold phases. To prevent automatic migration, you can explicitly include the migrate action and set the enabled option to `false`.
If the `cold` phase defines a [searchable snapshot action](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-searchable-snapshot) the `migrate` action will not be injected automatically in the `cold` phase because the managed index will be mounted directly on the target tier using the same `_tier_preference` infrastructure the `migrate` actions configures.
In the warm phase, the `migrate` action sets [`index.routing.allocation.include._tier_preference`](/docs/reference/elasticsearch/index-settings/data-tier-allocation#tier-preference-allocation-filter) to `data_warm,data_hot`. This moves the index to nodes in the [warm tier](https://www.elastic.co/docs/manage-data/lifecycle/data-tiers#warm-tier). If there are no nodes in the warm tier,  it falls back to the [hot tier](https://www.elastic.co/docs/manage-data/lifecycle/data-tiers#hot-tier).
In the cold phase, the `migrate` action sets `index.routing.allocation.include._tier_preference` to `data_cold,data_warm,data_hot`. This moves the index to nodes in the [cold tier](https://www.elastic.co/docs/manage-data/lifecycle/data-tiers#cold-tier). If there are no nodes in the cold tier, it falls back to the [warm](https://www.elastic.co/docs/manage-data/lifecycle/data-tiers#warm-tier) tier, or the [hot](https://www.elastic.co/docs/manage-data/lifecycle/data-tiers#hot-tier) tier if there are no warm nodes available.
The migrate action is not allowed in the frozen phase. The frozen phase directly mounts the searchable snapshot using a [`index.routing.allocation.include._tier_preference`](/docs/reference/elasticsearch/index-settings/data-tier-allocation#tier-preference-allocation-filter) of `data_frozen`. This moves the index to nodes in the [frozen tier](https://www.elastic.co/docs/manage-data/lifecycle/data-tiers#frozen-tier).
The migrate action is not allowed in the hot phase. The initial index allocation is performed [automatically](https://www.elastic.co/docs/manage-data/lifecycle/data-tiers#data-tier-allocation), and can be configured manually or via [index templates](https://www.elastic.co/docs/manage-data/data-store/templates).
For more index setting details, check out [Data tier allocation settings](https://www.elastic.co/docs/reference/elasticsearch/index-settings/data-tier-allocation).

## Options

<definitions>
  <definition term="enabled">
    (Optional, Boolean) Controls whether ILM automatically migrates the index during this phase. Defaults to `true`.
  </definition>
</definitions>


## Example

In the following policy, the [allocate](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-allocate) action is specified to reduce the number of replicas before ILM migrates the index to warm nodes.
<note>
  Explicitly specifying the migrate action is not required--ILM automatically performs the migrate action unless you disable migration.
</note>

```json

{
  "policy": {
    "phases": {
      "warm": {
        "actions": {
          "migrate" : {
          },
          "allocate": {
            "number_of_replicas": 1
          }
        }
      }
    }
  }
}
```


## Disable automatic migration

The migrate action in the following policy is disabled and the allocate action assigns the index to nodes that have a `rack_id` of *one* or *two*.
```json

{
  "policy": {
    "phases": {
      "warm": {
        "actions": {
          "migrate" : {
           "enabled": false
          },
          "allocate": {
            "include" : {
              "rack_id": "one,two"
            }
          }
        }
      }
    }
  }
}
```