﻿---
title: Delete
description: Phases allowed: delete. Permanently removes the index. 
url: https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-delete
products:
  - Elasticsearch
---

# Delete
Phases allowed: delete.
Permanently removes the index.

## Options

<definitions>
  <definition term="delete_searchable_snapshot">
    (Optional, Boolean) Deletes the searchable snapshot created in a previous phase. Defaults to `true`. This option is applicable when the [searchable snapshot](https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-searchable-snapshot) action is used in any previous phase.
    If you set this option to `false`, use the [Delete snapshots API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-snapshot-delete) to remove searchable snapshots from your snapshot repository when they are no longer needed.
    If you manually delete an index before the Index lifecycle management delete phase runs, then ILM will not delete the underlying searchable snapshot. Use the [Delete snapshots API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-snapshot-delete) to remove the searchable snapshot from your snapshot repository when it is no longer needed.
    See [Reliability of searchable snapshots](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/searchable-snapshots#searchable-snapshots-reliability) for further information about deleting searchable snapshots.
  </definition>
</definitions>

<warning>
  If a policy with a searchable snapshot action is applied on an existing searchable snapshot index, the snapshot backing this index will NOT be deleted because it was not created by this policy. If you want to clean this snapshot, please delete it manually after the index is deleted using the [delete snapshot API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-snapshot-delete), you can find the repository and snapshot name using the [get index API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-get).
</warning>


## Example

```json

{
  "policy": {
    "phases": {
      "delete": {
        "actions": {
          "delete" : { }
        }
      }
    }
  }
}
```