﻿---
title: Allocate
description: Phases allowed: warm, cold. Updates the index settings to change which nodes are allowed to host the index shards and change the number of replicas. The...
url: https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions/ilm-allocate
products:
  - Elasticsearch
---

# Allocate
Phases allowed: warm, cold.
Updates the index settings to change which nodes are allowed to host the index shards and change the number of replicas.
The allocate action is not allowed in the hot phase. The initial allocation for the index must be done manually or via [index templates](https://www.elastic.co/docs/manage-data/data-store/templates).
You can configure this action to modify both the allocation rules and number of replicas, only the allocation rules, or only the number of replicas. For more information about how Elasticsearch uses replicas for scaling, see [Get ready for production](https://www.elastic.co/docs/deploy-manage/production-guidance/elasticsearch-in-production-environments). See [Index-level shard allocation filtering](https://www.elastic.co/docs/reference/elasticsearch/index-settings/shard-allocation) for more information about controlling where Elasticsearch allocates shards of a particular index.

## Options

You must specify the number of replicas or at least one `include`, `exclude`, or `require` option. An empty allocate action is invalid.
For more information about using custom attributes for shard allocation, refer to [Index-level shard allocation settings](https://www.elastic.co/docs/reference/elasticsearch/index-settings/shard-allocation).
<definitions>
  <definition term="number_of_replicas">
    (Optional, integer) Number of replicas to assign to the index.
  </definition>
  <definition term="total_shards_per_node">
    (Optional, integer) The maximum number of shards for the index on a single Elasticsearch node. A value of `-1` is interpreted as unlimited. See [total shards](https://www.elastic.co/docs/reference/elasticsearch/index-settings/total-shards-per-node).
  </definition>
  <definition term="include">
    (Optional, object) Assigns an index to nodes that have at least *one* of the specified custom attributes.
  </definition>
  <definition term="exclude">
    (Optional, object) Assigns an index to nodes that have *none* of the specified custom attributes.
  </definition>
  <definition term="require">
    (Optional, object) Assigns an index to nodes that have *all* of the specified custom attributes.
  </definition>
</definitions>


## Example

The allocate action in the following policy changes the index’s number of replicas to `2`. No more than 200 shards for the index will be placed on any single node. Otherwise the index allocation rules are not changed.
```json

{
  "policy": {
    "phases": {
      "warm": {
        "actions": {
          "allocate" : {
            "number_of_replicas" : 2,
            "total_shards_per_node" : 200
          }
        }
      }
    }
  }
}
```


### Assign index to nodes using a custom attribute

The allocate action in the following policy assigns the index to nodes that have a `box_type` of *hot* or *warm*.
To designate a node’s `box_type`, you set a custom attribute in the node configuration. For example, set `node.attr.box_type: hot` in `elasticsearch.yml`. For more information, refer to [Index-level shard allocation settings > Enabling index-level shard allocation filtering](/docs/reference/elasticsearch/index-settings/shard-allocation#index-allocation-filters).
```json

{
  "policy": {
    "phases": {
      "warm": {
        "actions": {
          "allocate" : {
            "include" : {
              "box_type": "hot,warm"
            }
          }
        }
      }
    }
  }
}
```


### Assign index to nodes based on multiple attributes

The allocate action can also assign indices to nodes based on multiple node attributes. The following action assigns indices based on the `box_type` and `storage` node attributes.
```json

{
  "policy": {
    "phases": {
      "cold": {
        "actions": {
          "allocate" : {
            "require" : {
              "box_type": "cold",
              "storage": "high"
            }
          }
        }
      }
    }
  }
}
```


### Assign index to a specific node and update replica settings

The allocate action in the following policy updates the index to have one replica per shard and be allocated to nodes that have a `box_type` of *cold*.
To designate a node’s `box_type`, you set a custom attribute in the node configuration. For example, set `node.attr.box_type: cold` in `elasticsearch.yml`. For more information, refer to [Index-level shard allocation settings > Enabling index-level shard allocation filtering](/docs/reference/elasticsearch/index-settings/shard-allocation#index-allocation-filters).
```json

{
  "policy": {
    "phases": {
      "warm": {
        "actions": {
          "allocate" : {
            "number_of_replicas": 1,
            "require" : {
              "box_type": "cold"
            }
        }
        }
      }
    }
  }
}
```