﻿---
title: Index lifecycle actions
description: 
url: https://www.elastic.co/docs/reference/elasticsearch/index-lifecycle-actions
products:
  - Elasticsearch
---

# Index lifecycle actions
<note>
  This section provides detailed **reference information** for Index lifecycle actions.Refer to [Index lifecycle management](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management) in the **Manage data** section for overview, getting started and conceptual information.
</note>

<definitions>
  <definition term="Allocate">
    Move shards to nodes with different performance characteristics and reduce the number of replicas.
  </definition>
  <definition term="Delete">
    Permanently remove the index.
  </definition>
  <definition term="Force merge">
    Reduce the number of index segments and purge deleted documents.
  </definition>
  <definition term="Migrate">
    Move the index shards to the [data tier](https://www.elastic.co/docs/manage-data/lifecycle/data-tiers) that corresponds to the current ILM phase.
  </definition>
  <definition term="Read only">
    Block write operations to the index.
  </definition>
  <definition term="Rollover">
    Remove the index as the write index for the rollover alias and start indexing to a new index.
  </definition>
  <definition term="Downsample">
    Aggregates an index’s time series data and stores the results in a new read-only index. For example, you can downsample hourly data into daily or weekly summaries.
  </definition>
  <definition term="Searchable snapshot">
    Take a snapshot of the managed index in the configured repository and mount it as a searchable snapshot.
  </definition>
  <definition term="Set priority">
    Lower the priority of an index as it moves through the lifecycle to ensure that hot indices are recovered first.
  </definition>
  <definition term="Shrink">
    Reduce the number of primary shards by shrinking the index into a new index.
  </definition>
  <definition term="Unfollow">
    Convert a follower index to a regular index. Performed automatically before a rollover, shrink, or searchable snapshot action.
  </definition>
  <definition term="Wait for snapshot">
    Ensure that a snapshot exists before deleting the index.
  </definition>
</definitions>