﻿---
title: Snapshot action
description: This action will snapshot indices to the indicated repository, with a name, or name pattern, as identified by name. The other options are usually okay...
url: https://www.elastic.co/docs/reference/elasticsearch/curator/snapshot
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# Snapshot action
```yaml
action: snapshot
description: >-
  Snapshot selected indices to 'repository' with the snapshot name or name
  pattern in 'name'.  Use all other options as assigned
options:
  repository: ...
  # Leaving name blank will result in the default 'curator-%Y%m%d%H%M%S'
  name:
  wait_for_completion: True
  max_wait: 3600
  wait_interval: 10
filters:
- filtertype: ...
```

<note>
  Empty values and commented lines will result in the default value, if any, being selected.  If a setting is set, but not used by a given action, it will be ignored.
</note>

This action will snapshot indices to the indicated [repository](https://www.elastic.co/docs/reference/elasticsearch/curator/option_repository), with a name, or name pattern, as identified by [name](https://www.elastic.co/docs/reference/elasticsearch/curator/option_name).
The other options are usually okay to leave at the defaults, but feel free to read about them and change them accordingly.

## Required settings

- [repository](https://www.elastic.co/docs/reference/elasticsearch/curator/option_repository)


## Optional settings

- [search_pattern](https://www.elastic.co/docs/reference/elasticsearch/curator/option_search_pattern)
- [name](https://www.elastic.co/docs/reference/elasticsearch/curator/option_name)
- [ignore_unavailable](https://www.elastic.co/docs/reference/elasticsearch/curator/option_ignore)
- [include_global_state](https://www.elastic.co/docs/reference/elasticsearch/curator/option_include_gs)
- [partial](https://www.elastic.co/docs/reference/elasticsearch/curator/option_partial)
- [wait_for_completion](https://www.elastic.co/docs/reference/elasticsearch/curator/option_wfc)
- [max_wait](https://www.elastic.co/docs/reference/elasticsearch/curator/option_max_wait)
- [wait_interval](https://www.elastic.co/docs/reference/elasticsearch/curator/option_wait_interval)
- [skip_repo_fs_check](https://www.elastic.co/docs/reference/elasticsearch/curator/option_skip_fsck)
- [ignore_empty_list](https://www.elastic.co/docs/reference/elasticsearch/curator/option_ignore_empty)
- [timeout_override](https://www.elastic.co/docs/reference/elasticsearch/curator/option_timeout_override)
- [continue_if_exception](https://www.elastic.co/docs/reference/elasticsearch/curator/option_continue)
- [disable_action](https://www.elastic.co/docs/reference/elasticsearch/curator/option_disable)

<tip>
  See an example of this action in an [actionfile](https://www.elastic.co/docs/reference/elasticsearch/curator/actionfile) [here](https://www.elastic.co/docs/reference/elasticsearch/curator/ex_snapshot).
</tip>