﻿---
title: Shrink action
description: Shrinking an index is a good way to reduce the total shard count in your cluster. Several conditions need to be met in order for index shrinking to take...
url: https://www.elastic.co/docs/reference/elasticsearch/curator/shrink
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# Shrink action
```yaml
action: shrink
description: >-
  Shrink selected indices on the node with the most available space.
  Delete source index after successful shrink, then reroute the shrunk
  index with the provided parameters.
options:
  ignore_empty_list: True
  shrink_node: DETERMINISTIC
  node_filters:
    permit_masters: False
    exclude_nodes: ['not_this_node']
  number_of_shards: 1
  number_of_replicas: 1
  shrink_prefix:
  shrink_suffix: '-shrink'
  delete_after: True
  post_allocation:
    allocation_type: include
    key: node_tag
    value: cold
  wait_for_active_shards: 1
  extra_settings:
    settings:
      index.codec: best_compression
  wait_for_completion: True
  wait_for_rebalance: True
  wait_interval: 9
  max_wait: -1
filters:
  - filtertype: ...
```

<note>
  Empty values and commented lines will result in the default value, if any, being selected.  If a setting is set, but not used by a given action, it will be ignored.
</note>

Shrinking an index is a good way to reduce the total shard count in your cluster. [Several conditions need to be met](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-shrink) in order for index shrinking to take place:
- The index must be marked as read-only
- A (primary or replica) copy of every shard in the index must be relocated to the same node
- The cluster must have health `green`
- The target index must not exist
- The number of primary shards in the target index must be a factor of the number of primary shards in the source index.
- The source index must have more primary shards than the target index.
- The index must not contain more than 2,147,483,519 documents in total across all shards that will be shrunk into a single shard on the target index as this is the maximum number of docs that can fit into a single shard.
- The node handling the shrink process must have sufficient free disk space to accommodate a second copy of the existing index.

Curator will try to meet these conditions.  If it is unable to meet them all, it will not perform a shrink operation.
This action will shrink indices to the target index, the name of which is the value of [shrink_prefix](https://www.elastic.co/docs/reference/elasticsearch/curator/option_shrink_prefix) + the source index name + [shrink_suffix](https://www.elastic.co/docs/reference/elasticsearch/curator/option_shrink_suffix). The resulting index will have [number_of_shards](https://www.elastic.co/docs/reference/elasticsearch/curator/option_number_of_shards) primary shards, and [number_of_replicas](https://www.elastic.co/docs/reference/elasticsearch/curator/option_number_of_replicas) replica shards.
The shrinking will take place on the node identified by [shrink_node](https://www.elastic.co/docs/reference/elasticsearch/curator/option_shrink_node), unless `DETERMINISTIC` is specified, in which case Curator will evaluate all of the nodes to determine which one has the most free space.  If multiple indices are identified for shrinking by the filter block, and `DETERMINISTIC` is specified, the node selection process will be repeated for each successive index, preventing all of the space being consumed on a single node.
By default, Curator will delete the source index after a successful shrink. This can be disabled by setting [delete_after](https://www.elastic.co/docs/reference/elasticsearch/curator/option_delete_after) to `False`.  If the source index, is not deleted after a successful shrink, Curator will remove the read-only setting and the shard allocation routing applied to the source index to put it on the shrink node.  Curator will wait for the shards to stop rerouting before continuing.
The [post_allocation](https://www.elastic.co/docs/reference/elasticsearch/curator/option_post_allocation) option applies to the target index after the shrink is complete.  If set, this shard allocation routing will be applied (after a successful shrink) and Curator will wait for all shards to stop rerouting before continuing.
The only [extra_settings](https://www.elastic.co/docs/reference/elasticsearch/curator/option_extra_settings) which are acceptable are `settings` and `aliases`. Please note that in the example above, while `best_compression` is being applied to the new index, it will not take effect until new writes are made to the index, such as when [force-merging](https://www.elastic.co/docs/reference/elasticsearch/curator/forcemerge) the shard to a single segment.
The other options are usually okay to leave at the defaults, but feel free to change them as needed.

## Required settings

- [shrink_node](https://www.elastic.co/docs/reference/elasticsearch/curator/option_shrink_node)


## Optional settings

- [search_pattern](https://www.elastic.co/docs/reference/elasticsearch/curator/option_search_pattern)
- [continue_if_exception](https://www.elastic.co/docs/reference/elasticsearch/curator/option_continue)
- [ignore_empty_list](https://www.elastic.co/docs/reference/elasticsearch/curator/option_ignore_empty)
- [copy_aliases](https://www.elastic.co/docs/reference/elasticsearch/curator/option_copy_aliases)
- [delete_after](https://www.elastic.co/docs/reference/elasticsearch/curator/option_delete_after)
- [disable_action](https://www.elastic.co/docs/reference/elasticsearch/curator/option_disable)
- [extra_settings](https://www.elastic.co/docs/reference/elasticsearch/curator/option_extra_settings)
- [node_filters](https://www.elastic.co/docs/reference/elasticsearch/curator/option_node_filters)
- [number_of_shards](https://www.elastic.co/docs/reference/elasticsearch/curator/option_number_of_shards)
- [number_of_replicas](https://www.elastic.co/docs/reference/elasticsearch/curator/option_number_of_replicas)
- [post_allocation](https://www.elastic.co/docs/reference/elasticsearch/curator/option_post_allocation)
- [shrink_prefix](https://www.elastic.co/docs/reference/elasticsearch/curator/option_shrink_prefix)
- [shrink_suffix](https://www.elastic.co/docs/reference/elasticsearch/curator/option_shrink_suffix)
- [timeout_override](https://www.elastic.co/docs/reference/elasticsearch/curator/option_timeout_override)
- [wait_for_active_shards](https://www.elastic.co/docs/reference/elasticsearch/curator/option_wait_for_active_shards)
- [wait_for_completion](https://www.elastic.co/docs/reference/elasticsearch/curator/option_wfc)
- [wait_for_rebalance](https://www.elastic.co/docs/reference/elasticsearch/curator/option_wait_for_rebalance)
- [max_wait](https://www.elastic.co/docs/reference/elasticsearch/curator/option_max_wait)
- [wait_interval](https://www.elastic.co/docs/reference/elasticsearch/curator/option_wait_interval)

<tip>
  See an example of this action in an [actionfile](https://www.elastic.co/docs/reference/elasticsearch/curator/actionfile) [here](https://www.elastic.co/docs/reference/elasticsearch/curator/ex_shrink).
</tip>