﻿---
title: Rollover action
description: This action uses the Elasticsearch Rollover API to create a new index, if any of the described conditions are met. The extra_settings option allows the...
url: https://www.elastic.co/docs/reference/elasticsearch/curator/rollover
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# Rollover action
```yaml
action: rollover
description: >-
  Rollover the index associated with alias 'aliasname', which should be in the
  form of prefix-000001 (or similar), or prefix-YYYY.MM.DD-1.
options:
  name: aliasname
  conditions:
    max_age: 1d
    max_docs: 1000000
    max_size: 5gb
```

This action uses the Elasticsearch [Rollover API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-rollover) to create a new index, if any of the described conditions are met.
<important>
  When choosing `conditions`, **any** one of [max_age](https://www.elastic.co/docs/reference/elasticsearch/curator/option_max_age), [max_docs](https://www.elastic.co/docs/reference/elasticsearch/curator/option_max_docs), [max_size](https://www.elastic.co/docs/reference/elasticsearch/curator/option_max_size), **or any combination of the three** may be used. If multiple are used, then the specified condition for any one of them must be matched for the rollover to occur.
</important>

<warning>
  If one or more of the [max_age](https://www.elastic.co/docs/reference/elasticsearch/curator/option_max_age), [max_docs](https://www.elastic.co/docs/reference/elasticsearch/curator/option_max_docs), or [max_size](https://www.elastic.co/docs/reference/elasticsearch/curator/option_max_size) options are present, they must each have a value. Because there are no default values, none of these conditions can be left empty, or Curator will generate an error.
</warning>


## Extra settings

The [extra_settings](https://www.elastic.co/docs/reference/elasticsearch/curator/option_extra_settings) option allows the addition of extra index settings (but not mappings).  An example of how these settings can be used might be:
```yaml
action: rollover
description: >-
  Rollover the index associated with alias 'aliasname', which should be in the
  form of prefix-000001 (or similar), or prefix-YYYY.MM.DD-1.
options:
  name: aliasname
  conditions:
    max_age: 1d
    max_docs: 1000000
  extra_settings:
    index.number_of_shards: 3
    index.number_of_replicas: 1
  timeout_override:
  continue_if_exception: False
  disable_action: False
```


## Required settings

- [name](https://www.elastic.co/docs/reference/elasticsearch/curator/option_name) The alias name
- [max_age](https://www.elastic.co/docs/reference/elasticsearch/curator/option_max_age) The maximum age that is allowed before triggering a rollover. This *must* be nested under `conditions:`. There is no default value. If this condition is specified, it must have a value, or Curator will generate an error.
- [max_docs](https://www.elastic.co/docs/reference/elasticsearch/curator/option_max_docs) The maximum number of documents allowed in an index before triggering a rollover.  This *must* be nested under `conditions:`. There is no default value.  If this condition is specified, it must have a value, or Curator will generate an error.
- [max_size](https://www.elastic.co/docs/reference/elasticsearch/curator/option_max_size) The maximum size the index can be before a rollover is triggered. This *must* be nested under `conditions:`. There is no default value.  If this condition is specified, it must have a value, or Curator will generate an error.


## Optional settings

- [extra_settings](https://www.elastic.co/docs/reference/elasticsearch/curator/option_extra_settings) No default value.  You can add any acceptable index settings (not mappings) as nested YAML.  See the [Create an index API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-create) for more information.
- [new_index](https://www.elastic.co/docs/reference/elasticsearch/curator/option_new_index) Specify a new index name.
- [timeout_override](https://www.elastic.co/docs/reference/elasticsearch/curator/option_timeout_override)
- [continue_if_exception](https://www.elastic.co/docs/reference/elasticsearch/curator/option_continue)
- [disable_action](https://www.elastic.co/docs/reference/elasticsearch/curator/option_disable)

<tip>
  See an example of this action in an [actionfile](https://www.elastic.co/docs/reference/elasticsearch/curator/actionfile) [here](https://www.elastic.co/docs/reference/elasticsearch/curator/ex_rollover).
</tip>