﻿---
title: Restore action
description: This action will restore indices from the indicated repository, from the most recent snapshot identified by the applied filters, or the snapshot identified...
url: https://www.elastic.co/docs/reference/elasticsearch/curator/restore
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# Restore action
```yaml
actions:
  1:
    action: restore
    description: >-
      Restore all indices in the most recent snapshot with state SUCCESS.  Wait
      for the restore to complete before continuing.  Do not skip the repository
      filesystem access check.  Use the other options to define the index/shard
      settings for the restore.
    options:
      repository:
      # If name is blank, the most recent snapshot by age will be selected
      name:
      # If indices is blank, all indices in the snapshot will be restored
      indices:
      wait_for_completion: True
      max_wait: 3600
      wait_interval: 10
    filters:
    - filtertype: state
      state: SUCCESS
      exclude:
    - filtertype: ...
```

<note>
  Empty values and commented lines will result in the default value, if any, being selected.  If a setting is set, but not used by a given action, it will be ignored.
</note>

This action will restore indices from the indicated [repository](https://www.elastic.co/docs/reference/elasticsearch/curator/option_repository), from the most recent snapshot identified by the applied filters, or the snapshot identified by [name](https://www.elastic.co/docs/reference/elasticsearch/curator/option_name).

## Renaming indices on restore

You can cause indices to be renamed at restore with the [rename_pattern](https://www.elastic.co/docs/reference/elasticsearch/curator/option_rename_pattern) and [rename_replacement](https://www.elastic.co/docs/reference/elasticsearch/curator/option_rename_replacement) options:
```yaml
actions:
  1:
    action: restore
    description: >-
      Restore all indices in the most recent snapshot with state SUCCESS.  Wait
      for the restore to complete before continuing.  Do not skip the repository
      filesystem access check.  Use the other options to define the index/shard
      settings for the restore.
    options:
      repository:
      # If name is blank, the most recent snapshot by age will be selected
      name:
      # If indices is blank, all indices in the snapshot will be restored
      indices:
      rename_pattern: 'index(.+)'
      rename_replacement: 'restored_index$1'
      wait_for_completion: True
      max_wait: 3600
      wait_interval: 10
    filters:
    - filtertype: state
      state: SUCCESS
      exclude:
    - filtertype: ...
```

In this configuration, Elasticsearch will capture whatever appears after `index` and put it after `restored_index`.  For example, if I was restoring `index-2017.03.01`, the resulting index would be renamed to `restored_index-2017.03.01`.

## Extra settings

The [extra_settings](https://www.elastic.co/docs/reference/elasticsearch/curator/option_extra_settings) option allows the addition of extra settings, such as index settings.  An example of how these settings can be used to change settings for an index being restored might be:
```yaml
actions:
  1:
    action: restore
    description: >-
      Restore all indices in the most recent snapshot with state SUCCESS.  Wait
      for the restore to complete before continuing.  Do not skip the repository
      filesystem access check.  Use the other options to define the index/shard
      settings for the restore.
    options:
      repository:
      # If name is blank, the most recent snapshot by age will be selected
      name:
      # If indices is blank, all indices in the snapshot will be restored
      indices:
      extra_settings:
        index_settings:
          number_of_replicas: 0
      wait_for_completion: True
      max_wait: 3600
      wait_interval: 10
    filters:
    - filtertype: state
      state: SUCCESS
      exclude:
    - filtertype: ...
```

In this case, the number of replicas will be applied to the restored indices.
For more information, see the [Elasticsearch documentation](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/restore-snapshot).

## Required settings

- [repository](https://www.elastic.co/docs/reference/elasticsearch/curator/option_repository)


## Optional settings

- [name](https://www.elastic.co/docs/reference/elasticsearch/curator/option_name)
- [include_aliases](https://www.elastic.co/docs/reference/elasticsearch/curator/option_include_aliases)
- [indices](https://www.elastic.co/docs/reference/elasticsearch/curator/option_indices)
- [ignore_unavailable](https://www.elastic.co/docs/reference/elasticsearch/curator/option_ignore)
- [include_global_state](https://www.elastic.co/docs/reference/elasticsearch/curator/option_include_gs)
- [partial](https://www.elastic.co/docs/reference/elasticsearch/curator/option_partial)
- [rename_pattern](https://www.elastic.co/docs/reference/elasticsearch/curator/option_rename_pattern)
- [rename_replacement](https://www.elastic.co/docs/reference/elasticsearch/curator/option_rename_replacement)
- [extra_settings](https://www.elastic.co/docs/reference/elasticsearch/curator/option_extra_settings)
- [wait_for_completion](https://www.elastic.co/docs/reference/elasticsearch/curator/option_wfc)
- [max_wait](https://www.elastic.co/docs/reference/elasticsearch/curator/option_max_wait)
- [wait_interval](https://www.elastic.co/docs/reference/elasticsearch/curator/option_wait_interval)
- [skip_repo_fs_check](https://www.elastic.co/docs/reference/elasticsearch/curator/option_skip_fsck)
- [ignore_empty_list](https://www.elastic.co/docs/reference/elasticsearch/curator/option_ignore_empty)
- [timeout_override](https://www.elastic.co/docs/reference/elasticsearch/curator/option_timeout_override)
- [continue_if_exception](https://www.elastic.co/docs/reference/elasticsearch/curator/option_continue)
- [disable_action](https://www.elastic.co/docs/reference/elasticsearch/curator/option_disable)

<tip>
  See an example of this action in an [actionfile](https://www.elastic.co/docs/reference/elasticsearch/curator/actionfile) [here](https://www.elastic.co/docs/reference/elasticsearch/curator/ex_restore).
</tip>