﻿---
title: Replicas
description: This action will set the number of replicas per shard to the value of count. You can optionally set wait_for_completion to True to have Curator wait for...
url: https://www.elastic.co/docs/reference/elasticsearch/curator/replicas
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# Replicas
```yaml
action: replicas
description: >- Set the number of replicas per shard for selected
    indices to 'count'
options:
  count: ...
filters:
- filtertype: ...
```

<note>
  Empty values and commented lines will result in the default value, if any, being selected.  If a setting is set, but not used by a given action, it will be ignored.
</note>

This action will set the number of replicas per shard to the value of [count](https://www.elastic.co/docs/reference/elasticsearch/curator/option_count).
You can optionally set `wait_for_completion` to `True` to have Curator wait for the replication operation to complete before continuing:
```yaml
action: replicas
description: >- Set the number of replicas per shard for selected
    indices to 'count'
options:
  count: ...
  wait_for_completion: True
  max_wait: 600
  wait_interval: 10
filters:
- filtertype: ...
```

This configuration will wait for a maximum of 600 seconds for all index replicas to be complete before giving up.  A `max_wait` value of `-1` will wait indefinitely.  Curator will poll for completion at `10` second intervals, as defined by `wait_interval`.

## Required settings

- [count](https://www.elastic.co/docs/reference/elasticsearch/curator/option_count)


## Optional settings

- [search_pattern](https://www.elastic.co/docs/reference/elasticsearch/curator/option_search_pattern)
- [wait_for_completion](https://www.elastic.co/docs/reference/elasticsearch/curator/option_wfc)
- [max_wait](https://www.elastic.co/docs/reference/elasticsearch/curator/option_max_wait)
- [wait_interval](https://www.elastic.co/docs/reference/elasticsearch/curator/option_wait_interval)
- [ignore_empty_list](https://www.elastic.co/docs/reference/elasticsearch/curator/option_ignore_empty)
- [timeout_override](https://www.elastic.co/docs/reference/elasticsearch/curator/option_timeout_override)
- [continue_if_exception](https://www.elastic.co/docs/reference/elasticsearch/curator/option_continue)
- [disable_action](https://www.elastic.co/docs/reference/elasticsearch/curator/option_disable)

<tip>
  See an example of this action in an [actionfile](https://www.elastic.co/docs/reference/elasticsearch/curator/actionfile) [here](https://www.elastic.co/docs/reference/elasticsearch/curator/ex_replicas).
</tip>