﻿---
title: Reindex action
description: There are many options for the reindex option.  The best place to start is in the request_body documentation to see how to configure this action.  All...
url: https://www.elastic.co/docs/reference/elasticsearch/curator/reindex
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# Reindex action
```yaml
actions:
  1:
    description: "Reindex index1 into index2"
    action: reindex
    options:
      wait_interval: 9
      max_wait: -1
      request_body:
        source:
          index: index1
        dest:
          index: index2
    filters:
    - filtertype: none
```

There are many options for the reindex option.  The best place to start is in the [request_body documentation](https://www.elastic.co/docs/reference/elasticsearch/curator/option_request_body) to see how to configure this action.  All other options are as follows.

## Required settings

- [request_body](https://www.elastic.co/docs/reference/elasticsearch/curator/option_request_body)


## Optional settings

- [refresh](https://www.elastic.co/docs/reference/elasticsearch/curator/option_refresh)
- [remote_certificate](https://www.elastic.co/docs/reference/elasticsearch/curator/option_remote_certificate)
- [remote_client_cert](https://www.elastic.co/docs/reference/elasticsearch/curator/option_remote_client_cert)
- [remote_client_key](https://www.elastic.co/docs/reference/elasticsearch/curator/option_remote_client_key)
- [remote_filters](https://www.elastic.co/docs/reference/elasticsearch/curator/option_remote_filters)
- [remote_url_prefix](https://www.elastic.co/docs/reference/elasticsearch/curator/option_remote_url_prefix)
- [request_body](https://www.elastic.co/docs/reference/elasticsearch/curator/option_request_body)
- [requests_per_second](https://www.elastic.co/docs/reference/elasticsearch/curator/option_requests_per_second)
- [slices](https://www.elastic.co/docs/reference/elasticsearch/curator/option_slices)
- [timeout](https://www.elastic.co/docs/reference/elasticsearch/curator/option_timeout)
- [wait_for_active_shards](https://www.elastic.co/docs/reference/elasticsearch/curator/option_wait_for_active_shards)
- [wait_for_completion](https://www.elastic.co/docs/reference/elasticsearch/curator/option_wfc)
- [max_wait](https://www.elastic.co/docs/reference/elasticsearch/curator/option_max_wait)
- [wait_interval](https://www.elastic.co/docs/reference/elasticsearch/curator/option_wait_interval)
- [ignore_empty_list](https://www.elastic.co/docs/reference/elasticsearch/curator/option_ignore_empty)
- [timeout_override](https://www.elastic.co/docs/reference/elasticsearch/curator/option_timeout_override)
- [continue_if_exception](https://www.elastic.co/docs/reference/elasticsearch/curator/option_continue)
- [disable_action](https://www.elastic.co/docs/reference/elasticsearch/curator/option_disable)
- [migration_prefix](https://www.elastic.co/docs/reference/elasticsearch/curator/option_migration_prefix)
- [migration_suffix](https://www.elastic.co/docs/reference/elasticsearch/curator/option_migration_suffix)

<tip>
  See an example of this action in an [actionfile](https://www.elastic.co/docs/reference/elasticsearch/curator/actionfile) [here](https://www.elastic.co/docs/reference/elasticsearch/curator/ex_reindex).
</tip>


## Compatibility

Generally speaking, the Curator should be able to perform a remote reindex from any version of Elasticsearch, 1.4 and newer. Strictly speaking, the Reindex API in Elasticsearch *is* able to reindex from older clusters, but Curator cannot be used to facilitate this due to Curator’s dependency on changes released in 1.4.