﻿---
title: wait_for_completion
description: This setting must be either True or False. This setting specifies whether or not the request should return immediately or wait for the operation to complete...
url: https://www.elastic.co/docs/reference/elasticsearch/curator/option_wfc
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# wait_for_completion
<note>
  This setting is used by the [allocation](https://www.elastic.co/docs/reference/elasticsearch/curator/allocation), [cluster_routing](https://www.elastic.co/docs/reference/elasticsearch/curator/cluster_routing), [reindex](https://www.elastic.co/docs/reference/elasticsearch/curator/reindex), [replicas](https://www.elastic.co/docs/reference/elasticsearch/curator/replicas), [restore](https://www.elastic.co/docs/reference/elasticsearch/curator/restore), and [snapshot](https://www.elastic.co/docs/reference/elasticsearch/curator/snapshot) actions.
</note>

This setting must be either `True` or `False`.
This setting specifies whether or not the request should return immediately or wait for the operation to complete before returning.

## [allocation](https://www.elastic.co/docs/reference/elasticsearch/curator/allocation)

```yaml
action: allocation
description: "Apply shard allocation filtering rules to the specified indices"
options:
  key: ...
  value: ...
  allocation_type: ...
  wait_for_completion: False
  max_wait: 300
  wait_interval: 10
filters:
- filtertype: ...
```

The default value for the [allocation](https://www.elastic.co/docs/reference/elasticsearch/curator/allocation) action is `False`.

## [cluster_routing](https://www.elastic.co/docs/reference/elasticsearch/curator/cluster_routing)

```yaml
action: cluster_routing
description: "Apply routing rules to the entire cluster"
options:
  routing_type:
  value: ...
  setting: enable
  wait_for_completion: True
  max_wait: 300
  wait_interval: 10
```

The default value for the [cluster_routing](https://www.elastic.co/docs/reference/elasticsearch/curator/cluster_routing) action is `False`.

## [reindex](https://www.elastic.co/docs/reference/elasticsearch/curator/reindex)

```yaml
actions:
  1:
    description: "Reindex index1 into index2"
    action: reindex
    options:
      wait_interval: 9
      max_wait: -1
      request_body:
        source:
          index: index1
        dest:
          index: index2
    filters:
    - filtertype: none
```

The default value for the [reindex](https://www.elastic.co/docs/reference/elasticsearch/curator/reindex) action is `False`.

## [replicas](https://www.elastic.co/docs/reference/elasticsearch/curator/replicas)

```yaml
action: replicas
description: >- Set the number of replicas per shard for selected
    indices to 'count'
options:
  count: ...
  wait_for_completion: True
  max_wait: 600
  wait_interval: 10
filters:
- filtertype: ...
```

The default value for the [replicas](https://www.elastic.co/docs/reference/elasticsearch/curator/replicas) action is `False`.

## [restore](https://www.elastic.co/docs/reference/elasticsearch/curator/restore)

```yaml
actions:
  1:
    action: restore
    description: Restore my_index from my_snapshot in my_repository
    options:
      repository: my_repository
      name: my_snapshot
      indices: my_index
      wait_for_completion: True
      max_wait: 3600
      wait_interval: 10
    filters:
    - filtertype: state
      state: SUCCESS
      exclude:
    - filtertype: ...
```

The default value for the [restore](https://www.elastic.co/docs/reference/elasticsearch/curator/restore) action is `True`.

## [snapshot](https://www.elastic.co/docs/reference/elasticsearch/curator/snapshot)

```yaml
action: snapshot
description: >-
  Snapshot selected indices to 'repository' with the snapshot name or name
  pattern in 'name'.  Use all other options as assigned
options:
  repository: my_repository
  name: my_snapshot
  wait_for_completion: True
  max_wait: 3600
  wait_interval: 10
filters:
- filtertype: ...
```

The default value for the [snapshot](https://www.elastic.co/docs/reference/elasticsearch/curator/snapshot) action is `True`.
<tip>
  During snapshot initialization, information about all previous snapshots is loaded into the memory, which means that in large repositories it may take several seconds (or even minutes) for this command to return even if the `wait_for_completion` setting is set to `False`.
</tip>