﻿---
title: wait_for_active_shards
description: This setting determines the number of shard copies that must be active before the client returns. The default value is 1, which implies only the primary...
url: https://www.elastic.co/docs/reference/elasticsearch/curator/option_wait_for_active_shards
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# wait_for_active_shards
<note>
  This setting is used by the [Reindex](https://www.elastic.co/docs/reference/elasticsearch/curator/reindex), [Rollover](https://www.elastic.co/docs/reference/elasticsearch/curator/rollover), and [Shrink](https://www.elastic.co/docs/reference/elasticsearch/curator/shrink) actions.  Each use it similarly.
</note>

This setting determines the number of shard copies that must be active before the client returns. The default value is 1, which implies only the primary shards.
Set to `all` for all shard copies, otherwise set to any non-negative value less than or equal to the total number of copies for the shard (number of replicas + 1).
Read [the Elasticsearch documentation](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-create) for more information.

## Reindex

```yaml
actions:
  1:
    description: "Reindex index1,index2,index3 into new_index"
    action: reindex
    options:
      wait_interval: 9
      max_wait: -1
      wait_for_active_shards: 2
      request_body:
        source:
          index: ['index1', 'index2', 'index3']
        dest:
          index: new_index
    filters:
    - filtertype: none
```


## Rollover

```yaml
action: rollover
description: >-
  Rollover the index associated with alias 'name', which should be in the
  form of prefix-000001 (or similar), or prefix-yyyy.MM.DD-1.
options:
  name: aliasname
  conditions:
    max_age: 1d
    max_docs: 1000000
  wait_for_active_shards: 1
  extra_settings:
    index.number_of_shards: 3
    index.number_of_replicas: 1
  timeout_override:
  continue_if_exception: False
  disable_action: False
```


## Shrink

```yaml
action: shrink
description: >-
  Shrink selected indices on the node with the most available space.
  Prepend target index names with 'foo-' and append a suffix of '-shrink'
options:
  shrink_node: DETERMINISTIC
  wait_for_active_shards: all
filters:
  - filtertype: ...
```