﻿---
title: slices
description: This setting can speed up reindexing operations by using Sliced Scroll to slice on the _uid. Here are a few recommendations around the number of slices...
url: https://www.elastic.co/docs/reference/elasticsearch/curator/option_slices
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# slices
<note>
  This setting is only used by the [reindex](https://www.elastic.co/docs/reference/elasticsearch/curator/reindex) action.
</note>

This setting can speed up reindexing operations by using [Sliced Scroll](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/paginate-search-results#slice-scroll) to slice on the _uid.
```yaml
actions:
  1:
    description: "Reindex index1,index2,index3 into new_index"
    action: reindex
    options:
      wait_interval: 9
      max_wait: -1
      slices: 3
      request_body:
        source:
          index: ['index1', 'index2', 'index3']
        dest:
          index: new_index
    filters:
    - filtertype: none
```


## Picking the number of slices

Here are a few recommendations around the number of `slices` to use:
- Don’t use large numbers. `500` creates fairly massive CPU thrash, so Curator will not allow a number larger than this.
- It is more efficient from a query performance standpoint to use some multiple of the number of shards in the source index.
- Using exactly as many shards as are in the source index is the most efficient from a query performance standpoint.
- Indexing performance should scale linearly across available resources with the number of slices.
- Whether indexing or query performance dominates that process depends on lots of factors like the documents being reindexed and the cluster doing the reindexing.