﻿---
title: search_pattern
description: The value of this option can be a comma-separated list of data streams, indices, and aliases used to limit the request. Supports wildcards (*). To target...
url: https://www.elastic.co/docs/reference/elasticsearch/curator/option_search_pattern
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# search_pattern
<note>
  This setting is only used by the [*Allocation*](https://www.elastic.co/docs/reference/elasticsearch/curator/allocation), [*Close*](https://www.elastic.co/docs/reference/elasticsearch/curator/close), [*Cold2Frozen*](https://www.elastic.co/docs/reference/elasticsearch/curator/cold2frozen), [*Delete Indices*](https://www.elastic.co/docs/reference/elasticsearch/curator/delete_indices), [*Forcemerge*](https://www.elastic.co/docs/reference/elasticsearch/curator/forcemerge), [*Index Settings*](https://www.elastic.co/docs/reference/elasticsearch/curator/index_settings), [*Open*](https://www.elastic.co/docs/reference/elasticsearch/curator/open), [*Replicas*](https://www.elastic.co/docs/reference/elasticsearch/curator/replicas), [*Shrink*](https://www.elastic.co/docs/reference/elasticsearch/curator/shrink), and [*Snapshot*](https://www.elastic.co/docs/reference/elasticsearch/curator/snapshot) actions.
</note>

```yaml
action: delete_indices
description: "Delete selected indices"
options:
  search_pattern: 'index-*'
filters:
- filtertype: ...
```

The value of this option can be a comma-separated list of data streams, indices, and aliases used to limit the request. Supports wildcards (*). To target all data streams and indices, omit this parameter or use * or _all. If using wildcards it is highly recommended to encapsulate the entire search pattern in single quotes, e.g. `search_pattern: 'a*,b*,c*'`
The default value is `_all`.