﻿---
title: repository
description: There is no default value. This setting must be set by the user or an exception will be raised, and execution will halt. 
url: https://www.elastic.co/docs/reference/elasticsearch/curator/option_repository
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# repository
<note>
  This setting is only used by the [snapshot](https://www.elastic.co/docs/reference/elasticsearch/curator/snapshot), and [delete snapshots](https://www.elastic.co/docs/reference/elasticsearch/curator/delete_snapshots) actions.
</note>

There is no default value. This setting must be set by the user or an exception will be raised, and execution will halt.

## [restore](https://www.elastic.co/docs/reference/elasticsearch/curator/restore)

```yaml
actions:
  1:
    action: restore
    description: Restore my_index from my_snapshot in my_repository
    options:
      repository: my_repository
      name: my_snapshot
      indices: my_index
      wait_for_completion: True
      max_wait: 3600
      wait_interval: 10
    filters:
    - filtertype: state
      state: SUCCESS
      exclude:
    - filtertype: ...
```


## [snapshot](https://www.elastic.co/docs/reference/elasticsearch/curator/snapshot)

```yaml
action: snapshot
description: >-
  Snapshot selected indices to 'repository' with the snapshot name or name
  pattern in 'name'.  Use all other options as assigned
options:
  repository: my_repository
  name: my_snapshot
  wait_for_completion: True
  max_wait: 3600
  wait_interval: 10
filters:
- filtertype: ...
```