﻿---
title: rename_replacement
description: In this configuration, Elasticsearch will capture whatever appears after index and put it after restored_index.  For example, if I was restoring index-2017.03.01,...
url: https://www.elastic.co/docs/reference/elasticsearch/curator/option_rename_replacement
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# rename_replacement
<note>
  This setting is only used by the [restore](https://www.elastic.co/docs/reference/elasticsearch/curator/restore) action.
</note>

<admonition title="From the Elasticsearch documentation">
  The [rename_pattern](https://www.elastic.co/docs/reference/elasticsearch/curator/option_rename_pattern) and rename_replacement options can be also used to rename indices on restore using regular expression that supports referencing the original text as explained [here](http://docs.oracle.com/javase/6/docs/api/java/util/regex/Matcher.md#appendReplacement(java.lang.StringBuffer,%20java.lang.String)).
</admonition>

```yaml
actions:
  1:
    action: restore
    description: >-
      Restore all indices in the most recent snapshot with state SUCCESS.  Wait
      for the restore to complete before continuing.  Do not skip the repository
      filesystem access check.  Use the other options to define the index/shard
      settings for the restore.
    options:
      repository:
      # If name is blank, the most recent snapshot by age will be selected
      name:
      # If indices is blank, all indices in the snapshot will be restored
      indices:
      rename_pattern: 'index(.+)'
      rename_replacement: 'restored_index$1'
      wait_for_completion: True
      max_wait: 3600
      wait_interval: 10
    filters:
    - filtertype: state
      state: SUCCESS
      exclude:
    - filtertype: ...
```

In this configuration, Elasticsearch will capture whatever appears after `index` and put it after `restored_index`.  For example, if I was restoring `index-2017.03.01`, the resulting index would be renamed to `restored_index-2017.03.01`.
Read more about this setting in [Restore a snapshot](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/restore-snapshot).
There is no default value.