﻿---
title: remote_filters
description: This is an array of filters, exactly as with regular index selection: This feature will only work when the source index is set to REINDEX_SELECTION...
url: https://www.elastic.co/docs/reference/elasticsearch/curator/option_remote_filters
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# remote_filters
<note>
  This option is only used by the [Reindex action](https://www.elastic.co/docs/reference/elasticsearch/curator/reindex) when performing a remote reindex operation.
</note>

This is an array of [filters](https://www.elastic.co/docs/reference/elasticsearch/curator/filters), exactly as with regular index selection:
```yaml
actions:
  1:
    description: "Reindex matching indices into index2"
    action: reindex
    options:
      wait_interval: 9
      max_wait: -1
      request_body:
        source:
          remote:
            host: <OTHER_HOST_URL>:9200
          index: REINDEX_SELECTION
        dest:
          index: index2
      remote_filters:
      - filtertype: *first*
        setting1: ...
        ...
        settingN: ...
      - filtertype: *second*
        setting1: ...
        ...
        settingN: ...
      - filtertype: *third*
    filters:
    - filtertype: none
```

This feature will only work when the `source` `index` is set to `REINDEX_SELECTION`.  It will select *remote* indices matching the filters provided, and reindex them to the *local* cluster as the name provided in the `dest` `index`.  In this example, that is `index2`.