﻿---
title: remote_client_key
description: This should be a file path to a client key (private key), or left empty. Allows the use of a specified SSL client key file to authenticate to Elasticsearch...
url: https://www.elastic.co/docs/reference/elasticsearch/curator/option_remote_client_key
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# remote_client_key
<note>
  This option is only used by the [Reindex action](https://www.elastic.co/docs/reference/elasticsearch/curator/reindex) when performing a remote reindex operation.
</note>

This should be a file path to a client key (private key), or left empty.
```yaml
actions:
  1:
    description: "Reindex index1 into index2"
    action: reindex
    options:
      wait_interval: 9
      max_wait: -1
      remote_certificate: /path/to/my/ca.cert
      remote_client_cert: /path/to/my/client.cert
      remote_client_key: /path/to/my/client.key
      request_body:
        source:
          remote:
            host: <OTHER_HOST_URL>:9200
          index: index1
        dest:
          index: index2
    filters:
    - filtertype: none
```

Allows the use of a specified SSL client key file to authenticate to Elasticsearch. If using [client_cert](/docs/reference/elasticsearch/curator/configfile#client_cert) and the file specified does not also contain the key, use `client_key` to specify the file containing the SSL key. The key file must be an unencrypted key in PEM format.