﻿---
title: refresh
description: Setting refresh to True will cause all re-indexed indexes to be refreshed. This differs from the Index API’s refresh parameter which causes just the shard...
url: https://www.elastic.co/docs/reference/elasticsearch/curator/option_refresh
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# refresh
<note>
  This setting is only used by the [reindex](https://www.elastic.co/docs/reference/elasticsearch/curator/reindex) action.
</note>

```yaml
actions:
  1:
    description: "Reindex index1 into index2"
    action: reindex
    options:
      wait_interval: 9
      max_wait: -1
      refresh: True
      request_body:
        source:
          index: index1
        dest:
          index: index2
    filters:
    - filtertype: none
```

Setting `refresh` to `True` will cause all re-indexed indexes to be refreshed. This differs from the Index API’s refresh parameter which causes just the *shard* that received the new data to be refreshed.
Read more about this setting in the [Reindex API documentation](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-reindex).
The default value is `True`.