﻿---
title: post_allocation
description: The only permitted subkeys for post_allocation are the same options used by the allocation action: allocation_type, key, and value. If present, these...
url: https://www.elastic.co/docs/reference/elasticsearch/curator/option_post_allocation
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# post_allocation
<note>
  This setting is only used by the [shrink](https://www.elastic.co/docs/reference/elasticsearch/curator/shrink) action.
</note>

```yaml
action: shrink
description: >-
  Shrink selected indices on the node with the most available space.
  Apply shard routing allocation to target indices.
options:
  shrink_node: DETERMINISTIC
  post_allocation:
    allocation_type: include
    key: node_tag
    value: cold
filters:
  - filtertype: ...
```

The only permitted subkeys for `post_allocation` are the same options used by the [allocation](https://www.elastic.co/docs/reference/elasticsearch/curator/allocation) action: [allocation_type](https://www.elastic.co/docs/reference/elasticsearch/curator/option_allocation_type), [key](https://www.elastic.co/docs/reference/elasticsearch/curator/option_key), and [value](https://www.elastic.co/docs/reference/elasticsearch/curator/option_value).
If present, these values will be use to apply shard routing allocation to the target index after shrinking.
There is no default value for `post_allocation`.