﻿---
title: number_of_shards
description: The value of this setting determines the number of primary shards in the target index.  The default value is 1. 
url: https://www.elastic.co/docs/reference/elasticsearch/curator/option_number_of_shards
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# number_of_shards
<note>
  This setting is only used by the [shrink](https://www.elastic.co/docs/reference/elasticsearch/curator/shrink) action.
</note>

```yaml
action: shrink
description: >-
  Shrink selected indices on the node with the most available space.
  Set the number of shards to 2.
options:
  shrink_node: DETERMINISTIC
  number_of_shards: 2
filters:
  - filtertype: ...
```

The value of this setting determines the number of primary shards in the target index.  The default value is `1`.
<important>
  The value for `number_of_shards` must meet the following criteria:
  - It must be lower than the number of primary shards in the source index.
  - It must be a factor of the number of primary shards in the source index.
</important>