﻿---
title: node_filters
description: There is no default value for node_filters. The current sub-options are as follows: This option indicates whether the shrink action can select master...
url: https://www.elastic.co/docs/reference/elasticsearch/curator/option_node_filters
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# node_filters
<note>
  This setting is only used by the [shrink](https://www.elastic.co/docs/reference/elasticsearch/curator/shrink) action.
</note>

```yaml
action: shrink
description: >-
  Shrink selected indices on the node with the most available space.
  Allow master/data nodes to be potential shrink targets, but exclude
  'named_node' from potential selection.
options:
  shrink_node: DETERMINISTIC
  node_filters:
    permit_masters: True
    exclude_nodes: ['named_node']
filters:
  - filtertype: ...
```

There is no default value for `node_filters`.
The current sub-options are as follows:

## permit_masters

This option indicates whether the shrink action can select master eligible nodes when using `DETERMINISTIC` as the value for [shrink_node](https://www.elastic.co/docs/reference/elasticsearch/curator/option_shrink_node). The default value is `False`. Please note that this will exclude the elected master, as well as other master-eligible nodes.
<important>
  If you have a small cluster with only master/data nodes, you must set `permit_masters` to `True` in order to select one of those nodes as a potential [shrink_node](https://www.elastic.co/docs/reference/elasticsearch/curator/option_shrink_node).
</important>


## exclude_nodes

This option provides means to exclude nodes from selection when using `DETERMINISTIC` as the value for [shrink_node](https://www.elastic.co/docs/reference/elasticsearch/curator/option_shrink_node).  It should be noted that you *can* use a named node for [shrink_node](https://www.elastic.co/docs/reference/elasticsearch/curator/option_shrink_node) and then exclude it here, and it will prevent a shrink from occurring.