﻿---
title: max_wait
description: This setting must be a positive integer, or -1. This setting specifies how long in seconds to wait to see if the action has completed before giving up...
url: https://www.elastic.co/docs/reference/elasticsearch/curator/option_max_wait
products:
  - Elasticsearch
  - Elasticsearch Curator
---

# max_wait
<note>
  This setting is used by the [allocation](https://www.elastic.co/docs/reference/elasticsearch/curator/allocation), [cluster_routing](https://www.elastic.co/docs/reference/elasticsearch/curator/cluster_routing), [reindex](https://www.elastic.co/docs/reference/elasticsearch/curator/reindex), [replicas](https://www.elastic.co/docs/reference/elasticsearch/curator/replicas), [restore](https://www.elastic.co/docs/reference/elasticsearch/curator/restore), and [snapshot](https://www.elastic.co/docs/reference/elasticsearch/curator/snapshot) actions.
</note>

This setting must be a positive integer, or `-1`.
This setting specifies how long in seconds to wait to see if the action has completed before giving up.  This option is used in conjunction with [wait_interval](https://www.elastic.co/docs/reference/elasticsearch/curator/option_wait_interval), which is the number of seconds to wait between checking to see if the given action is complete.
The default value for this setting is `-1`, meaning that Curator will wait indefinitely for the action to complete.

## [allocation](https://www.elastic.co/docs/reference/elasticsearch/curator/allocation)

```yaml
action: allocation
description: "Apply shard allocation filtering rules to the specified indices"
options:
  key: ...
  value: ...
  allocation_type: ...
  wait_for_completion: True
  max_wait: 300
  wait_interval: 10
filters:
- filtertype: ...
```


## [cluster_routing](https://www.elastic.co/docs/reference/elasticsearch/curator/cluster_routing)

```yaml
action: cluster_routing
description: "Apply routing rules to the entire cluster"
options:
  routing_type:
  value: ...
  setting: enable
  wait_for_completion: True
  max_wait: 300
  wait_interval: 10
```


## [reindex](https://www.elastic.co/docs/reference/elasticsearch/curator/reindex)

```yaml
actions:
  1:
    description: "Reindex index1 into index2"
    action: reindex
    options:
      wait_interval: 9
      max_wait: -1
      request_body:
        source:
          index: index1
        dest:
          index: index2
    filters:
    - filtertype: none
```


## [replicas](https://www.elastic.co/docs/reference/elasticsearch/curator/replicas)

```yaml
action: replicas
description: >- Set the number of replicas per shard for selected
    indices to 'count'
options:
  count: ...
  wait_for_completion: True
  max_wait: 600
  wait_interval: 10
filters:
- filtertype: ...
```


## [restore](https://www.elastic.co/docs/reference/elasticsearch/curator/restore)

```yaml
actions:
  1:
    action: restore
    description: Restore my_index from my_snapshot in my_repository
    options:
      repository: my_repository
      name: my_snapshot
      indices: my_index
      include_global_state: False
      wait_for_completion: True
      max_wait: 3600
      wait_interval: 10
    filters:
    - filtertype: state
      state: SUCCESS
      exclude:
    - filtertype: ...
```


## [snapshot](https://www.elastic.co/docs/reference/elasticsearch/curator/snapshot)

```yaml
action: snapshot
description: >-
  Snapshot selected indices to 'repository' with the snapshot name or name
  pattern in 'name'.  Use all other options as assigned
options:
  repository: my_repository
  name: my_snapshot
  include_global_state: True
  wait_for_completion: True
  max_wait: 3600
  wait_interval: 10
filters:
- filtertype: ...
```